
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="cornichons", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="strips_of_bacon", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x3 = model.addVar(name="slices_of_pizza", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7 * x1 + (x2 + 1) * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7 * x1 + 6 * x2 <= 22, name="fiber_from_cornichons_and_bacon")
    model.addConstr(7 * x1 + x3 <= 22, name="fiber_from_cornichons_and_pizza")
    model.addConstr(7 * x1 + 6 * x2 + x3 <= 23, name="fiber_from_all_sources")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cornichons: {x1.varValue}")
        print(f"Strips of bacon: {x2.varValue}")
        print(f"Slices of pizza: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
