
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by John
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Dale
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by Mary
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")  # hours worked by Bobby


# Set objective function
m.setObjective(4*x0**2 + 9*x0*x1 + 8*x0*x2 + 9*x0*x3 + 2*x1**2 + 3*x1*x2 + 5*x1*x3 + 4*x2**2 + 1*x2*x3 + 6*x3**2 + 5*x0 + 6*x1 + 1*x2 + 9*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x0**2 + 1*x1**2 + 9*x2**2 >= 10)
m.addConstr(2*x0 + 1*x1 + 12*x3 >= 10)
m.addConstr(1*x1 + 9*x2 + 12*x3 >= 10)
m.addConstr(2*x0 + 1*x1 + 9*x2 >= 12)
m.addConstr(2*x0 + 1*x1 + 12*x3 >= 12)
m.addConstr(1*x1**2 + 9*x2**2 + 12*x3**2 >= 12)
m.addConstr(2*x0**2 + 1*x1**2 + 9*x2**2 >= 11)
m.addConstr(2*x0**2 + 1*x1**2 + 12*x3**2 >= 11)
m.addConstr(1*x1 + 9*x2 + 12*x3 >= 11)
m.addConstr(12*x0 + 6*x1 >= 14)
m.addConstr(12*x0 + 5*x2 >= 15)
m.addConstr(5*x2 + 13*x3 >= 17)
m.addConstr(12*x0 + 13*x3 >= 15)
m.addConstr(14*x0**2 + 6*x1**2 >= 11)
m.addConstr(6*x1 + 11*x2 >= 9)
m.addConstr(6*x1 + 11*x3 >= 19)
m.addConstr(14*x0**2 + 11*x2**2 >= 14)
m.addConstr(2*x0 - 2*x2 - 8*x3 >= 0)
m.addConstr(1*x1 + 12*x3 <= 35)
m.addConstr(2*x0**2 + 9*x2**2 <= 56)
m.addConstr(2*x0**2 + 12*x3**2 <= 45)
m.addConstr(1*x1 + 9*x2 <= 62)
m.addConstr(9*x2**2 + 12*x3**2 <= 56)
m.addConstr(2*x0 + 1*x1 <= 52)
m.addConstr(1*x1**2 + 9*x2**2 + 12*x3**2 <= 54)
m.addConstr(2*x0 + 1*x1 + 9*x2 <= 30)
m.addConstr(2*x0 + 1*x1 + 12*x3 <= 55)
m.addConstr(2*x0 + 1*x1 + 9*x2 + 12*x3 <= 55)
m.addConstr(6*x1 + 5*x2 <= 47)
m.addConstr(12*x0**2 + 6*x1**2 <= 27)
m.addConstr(5*x2**2 + 13*x3**2 <= 89)
m.addConstr(12*x0**2 + 6*x1**2 + 5*x2**2 <= 52)
m.addConstr(6*x1**2 + 5*x2**2 + 13*x3**2 <= 62)
m.addConstr(12*x0 + 6*x1 + 5*x2 + 13*x3 <= 62)
m.addConstr(11*x2 + 11*x3 <= 96)
m.addConstr(6*x1**2 + 11*x3**2 <= 36)
m.addConstr(14*x0 + 11*x2 <= 93)
m.addConstr(6*x1**2 + 11*x2**2 <= 29)
m.addConstr(14*x0 + 6*x1 + 11*x2 + 11*x3 <= 29)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

