
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="grams_of_fat")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="milligrams_of_vitamin_E")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milligrams_of_vitamin_B1")
x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milligrams_of_vitamin_A")
x4 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milligrams_of_vitamin_C")


# Set objective function
obj = 1.83*x0**2 + 8.56*x0*x1 + 7.73*x0*x2 + 3.94*x0*x3 + 7.98*x0*x4 + 4.15*x1**2 + 1.78*x1*x2 + 2.28*x1*x3 + 7.57*x1*x4 + 3.2*x2**2 + 4.42*x2*x3 + 7.06*x2*x4 + 4.1*x3**2 + 8.39*x3*x4 + 6.68*x4**2 + 6.82*x0 + 8.6*x1 + 3.58*x2 + 6.45*x3 + 2.31*x4

m.setObjective(obj, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x0 + 20*x1 + 26*x2 + 25*x3 + 22*x4 <= 391, "c0")
m.addConstr(11*x0 + 20*x1 + 7*x2 + 29*x3 + 11*x4 <= 483, "c1")
m.addConstr(26*x2**2 + 22*x4**2 >= 29, "c2")
m.addConstr(4*x0**2 + 25*x3**2 >= 28, "c3")
m.addConstr(4*x0 + 20*x1 >= 51, "c4")
m.addConstr(4*x0**2 + 20*x1**2 + 25*x3**2 >= 39, "c5")
m.addConstr(20*x1 + 26*x2 + 25*x3 >= 39, "c6")
m.addConstr(4*x0 + 20*x1 + 26*x2 >= 39, "c7")
m.addConstr(20*x1 + 26*x2 + 22*x4 >= 39, "c8")
m.addConstr(4*x0**2 + 20*x1**2 + 25*x3**2 >= 76, "c9")
m.addConstr(20*x1 + 26*x2 + 25*x3 >= 76, "c10")
m.addConstr(4*x0 + 20*x1 + 26*x2 >= 76, "c11")
m.addConstr(20*x1 + 26*x2 + 22*x4 >= 76, "c12")
m.addConstr(4*x0 + 20*x1 + 25*x3 >= 53, "c13")
m.addConstr(20*x1 + 26*x2 + 25*x3 >= 53, "c14")
m.addConstr(4*x0 + 20*x1 + 26*x2 >= 53, "c15")
m.addConstr(20*x1 + 26*x2 + 22*x4 >= 53, "c16")
m.addConstr(4*x0 + 20*x1 + 25*x3 >= 47, "c17")
m.addConstr(20*x1 + 26*x2 + 25*x3 >= 47, "c18")
m.addConstr(4*x0**2 + 20*x1**2 + 26*x2**2 >= 47, "c19")
m.addConstr(20*x1 + 26*x2 + 22*x4 >= 47, "c20")
m.addConstr(26*x2**2 + 25*x3**2 <= 324, "c21")
m.addConstr(20*x1 + 22*x4 <= 162, "c22")
m.addConstr(4*x0 + 20*x1 <= 322, "c23")
m.addConstr(4*x0**2 + 26*x2**2 <= 244, "c24")
m.addConstr(4*x0 + 20*x1 + 26*x2 + 25*x3 + 22*x4 <= 244, "c25")
m.addConstr(29*x3 + 11*x4 <= 240, "c26")
m.addConstr(20*x1 + 29*x3 <= 122, "c27")
m.addConstr(11*x0 + 20*x1 + 7*x2 + 29*x3 + 11*x4 <= 122, "c28")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

