
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B7
x1 = m.addVar(vtype=GRB.INTEGER, name="x1")  # grams of fat
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2")  # milligrams of potassium
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="x3")  # grams of protein


# Set objective function
m.setObjective(5*x0 + 2*x1 + 2*x2 + 6*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13.69*x0 + 6.32*x1 >= 80)
m.addConstr(6.32*x1 + 2.58*x3 >= 55)
m.addConstr(6.32*x1 + 12.48*x2 >= 54)
m.addConstr(13.69*x0 + 6.32*x1 + 12.48*x2 >= 69)
m.addConstr(13.69*x0 + 12.48*x2 + 2.58*x3 >= 69)
m.addConstr(6.32*x1 + 12.48*x2 + 2.58*x3 >= 69)
m.addConstr(13.69*x0 + 6.32*x1 + 12.48*x2 >= 67)
m.addConstr(13.69*x0 + 12.48*x2 + 2.58*x3 >= 67)
m.addConstr(6.32*x1 + 12.48*x2 + 2.58*x3 >= 67)
m.addConstr(13.69*x0 + 6.32*x1 + 12.48*x2 >= 70)
m.addConstr(13.69*x0 + 12.48*x2 + 2.58*x3 >= 70)
m.addConstr(6.32*x1 + 12.48*x2 + 2.58*x3 >= 70)
m.addConstr(20.29*x0 + 13.15*x2 >= 60)
m.addConstr(20.29*x0 + 19.67*x1 >= 43)
m.addConstr(13.15*x2 + 24.51*x3 >= 103)
m.addConstr(19.67*x1 + 24.51*x3 >= 78)
m.addConstr(19.67*x1 + 13.15*x2 + 24.51*x3 >= 109)
m.addConstr(5*x0 - x2 + 8*x3 >= 0)
m.addConstr(13.69*x0 + 2.58*x3 <= 226)
m.addConstr(13.69*x0 + 6.32*x1 <= 270)
m.addConstr(6.32*x1 + 2.58*x3 <= 104)
m.addConstr(6.32*x1 + 12.48*x2 <= 165)
m.addConstr(13.69*x0 + 6.32*x1 + 12.48*x2 + 2.58*x3 <= 165)
m.addConstr(20.29*x0 + 13.15*x2 <= 198)
m.addConstr(19.67*x1 + 13.15*x2 <= 222)
m.addConstr(13.15*x2 + 24.51*x3 <= 120)
m.addConstr(20.29*x0 + 19.67*x1 <= 317)
m.addConstr(20.29*x0 + 19.67*x1 + 13.15*x2 + 24.51*x3 <= 317)

# Add non-negativity constraints
m.addConstr(x0 >= 0)
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)
m.addConstr(x3 >= 0)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

