
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='cherry_pies', lb=0)
    x1 = model.addVar(name='tomatoes', lb=0)
    x2 = model.addVar(name='ravioli', lb=0)
    x3 = model.addVar(name='rotisserie_chickens', lb=0)

    # Define the objective function
    model.setObjective(6.18 * x0 + 1.21 * x1 + 2.81 * x2 + 6.74 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5 * x0 + 2 * x1 + 8 * x2 + 2 * x3 <= 82)
    model.addConstr(8 * x0 + 8 * x1 + 2 * x2 + 2 * x3 <= 60)
    model.addConstr(2 * x1 + 2 * x3 >= 7)
    model.addConstr(5 * x0 + 2 * x3 >= 10)
    model.addConstr(5 * x0 + 8 * x2 >= 18)
    model.addConstr(5 * x0 + 2 * x1 >= 6)
    model.addConstr(8 * x0 + 2 * x2 + 2 * x3 >= 10)
    model.addConstr(8 * x0 + 8 * x1 + 2 * x3 >= 10)
    model.addConstr(8 * x1 + 2 * x2 + 2 * x3 >= 10)
    model.addConstr(8 * x0 + 2 * x2 + 2 * x3 >= 15)
    model.addConstr(8 * x0 + 8 * x1 + 2 * x3 >= 15)
    model.addConstr(8 * x1 + 2 * x2 + 2 * x3 >= 15)
    model.addConstr(5 * x0 + 2 * x1 <= 27)
    model.addConstr(5 * x0 + 2 * x3 <= 51)
    model.addConstr(5 * x0 + 8 * x2 <= 42)
    model.addConstr(5 * x0 + 2 * x1 + 8 * x2 + 2 * x3 <= 42)
    model.addConstr(8 * x0 + 2 * x2 <= 34)
    model.addConstr(2 * x2 + 2 * x3 <= 56)
    model.addConstr(8 * x0 + 8 * x1 + 2 * x2 + 2 * x3 <= 56)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('cherry_pies: ', x0.varValue)
        print('tomatoes: ', x1.varValue)
        print('ravioli: ', x2.varValue)
        print('rotisserie_chickens: ', x3.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
