
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("vitamin_optimization")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B5
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin A


    # Set objective function
    model.setObjective(5*x0 + 7*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(13*x0 + 16*x1 >= 10, "c0")
    model.addConstr(4*x0 + 16*x1 >= 27, "c1")
    model.addConstr(5*x0 + 5*x1 >= 14, "c2")
    model.addConstr(13*x0 + 8*x1 >= 30, "c3")
    model.addConstr(2*x0 + 3*x1 >= 19, "c4")
    model.addConstr(10*x0 - 2*x1 >= 0, "c5")
    model.addConstr(13*x0 + 16*x1 <= 33, "c6")
    model.addConstr(4*x0 + 16*x1 <= 60, "c7")
    model.addConstr(5*x0 + 5*x1 <= 84, "c8")
    model.addConstr(13*x0 + 8*x1 <= 87, "c9")
    model.addConstr(2*x0 + 3*x1 <= 53, "c10")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
