
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_vitamin_B5", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="milligrams_of_vitamin_A", lb=0)   # No lower bound specified, assuming 0

    # Objective function
    model.setObjective(5 * x1 + 7 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(13 * x1 + 16 * x2 >= 10)
    model.addConstr(4 * x1 + 16 * x2 >= 27)
    model.addConstr(5 * x1 + 5 * x2 >= 14)
    model.addConstr(13 * x1 + 8 * x2 >= 30)
    model.addConstr(2 * x1 + 3 * x2 >= 19)
    model.addConstr(10 * x1 - 2 * x2 >= 0)
    model.addConstr(13 * x1 + 16 * x2 <= 33)
    model.addConstr(4 * x1 + 16 * x2 <= 60)
    model.addConstr(5 * x1 + 5 * x2 <= 84)
    model.addConstr(13 * x1 + 8 * x2 <= 87)
    model.addConstr(2 * x1 + 3 * x2 <= 53)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B5: {x1.varValue}")
        print(f"Milligrams of vitamin A: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
