
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
ringo_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo_hours")
mary_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")
dale_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")


# Set objective function
m.setObjective(3 * laura_hours + 1 * ringo_hours + 3 * mary_hours + 6 * dale_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * laura_hours + 22 * dale_hours >= 45)
m.addConstr(13 * ringo_hours + 31 * mary_hours >= 98)
m.addConstr(9 * laura_hours + 13 * ringo_hours + 22 * dale_hours >= 83)
m.addConstr(10 * laura_hours + 6 * mary_hours >= 43)
m.addConstr(6 * mary_hours + 18 * dale_hours >= 68)
m.addConstr(6 * laura_hours + 4 * dale_hours >= 24)
m.addConstr(6 * laura_hours + 8 * mary_hours >= 49)
m.addConstr(6 * laura_hours + 1 * ringo_hours + 4 * dale_hours >= 56)
m.addConstr(6 * laura_hours + 1 * ringo_hours + 8 * mary_hours >= 56)
m.addConstr(6 * laura_hours + 1 * ringo_hours + 4 * dale_hours >= 32)
m.addConstr(6 * laura_hours + 1 * ringo_hours + 8 * mary_hours >= 32)
m.addConstr(13 * ringo_hours + 31 * mary_hours <= 424)
m.addConstr(31 * mary_hours + 22 * dale_hours <= 336)
m.addConstr(9 * laura_hours + 22 * dale_hours <= 316)
m.addConstr(13 * ringo_hours + 22 * dale_hours <= 262)
m.addConstr(9 * laura_hours + 31 * mary_hours <= 390)
m.addConstr(13 * ringo_hours + 31 * mary_hours + 22 * dale_hours <= 289)
m.addConstr(9 * laura_hours + 13 * ringo_hours + 22 * dale_hours <= 126)
m.addConstr(9 * laura_hours + 13 * ringo_hours + 31 * mary_hours <= 211)
m.addConstr(9 * laura_hours + 13 * ringo_hours + 31 * mary_hours + 22 * dale_hours <= 211)
m.addConstr(10 * laura_hours + 6 * mary_hours <= 266)
m.addConstr(6 * mary_hours + 18 * dale_hours <= 166)
m.addConstr(5 * ringo_hours + 6 * mary_hours <= 170)
m.addConstr(10 * laura_hours + 18 * dale_hours <= 93)
m.addConstr(5 * ringo_hours + 18 * dale_hours <= 221)
m.addConstr(10 * laura_hours + 5 * ringo_hours + 6 * mary_hours + 18 * dale_hours <= 221)
m.addConstr(1 * ringo_hours + 8 * mary_hours <= 60)
m.addConstr(6 * laura_hours + 8 * mary_hours <= 71)
m.addConstr(1 * ringo_hours + 8 * mary_hours + 4 * dale_hours <= 63)
m.addConstr(6 * laura_hours + 1 * ringo_hours + 4 * dale_hours <= 182)
m.addConstr(6 * laura_hours + 8 * mary_hours + 4 * dale_hours <= 76)
m.addConstr(6 * laura_hours + 1 * ringo_hours + 8 * mary_hours + 4 * dale_hours <= 76)
m.addConstr(21 * laura_hours + 12 * mary_hours <= 193)
m.addConstr(12 * mary_hours + 31 * dale_hours <= 251)
m.addConstr(21 * laura_hours + 30 * ringo_hours + 12 * mary_hours + 31 * dale_hours <= 251)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print("Variable values:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

