
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b5 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b5")
vitamin_b3 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b3")
vitamin_e = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_e")
magnesium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="magnesium")
vitamin_k = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_k")
potassium = m.addVar(vtype=gp.GRB.INTEGER, name="potassium")


# Set objective function
m.setObjective(1.95 * vitamin_b5 + 4.9 * vitamin_b3 + 4.7 * vitamin_e + 5.98 * magnesium + 6.81 * vitamin_k + 3.54 * potassium, gp.GRB.MINIMIZE)

# Add constraints - Digestive Support
m.addConstr(2.78 * vitamin_b5 + 4.63 * vitamin_b3 + 4.35 * vitamin_e + 2.02 * magnesium + 0.62 * vitamin_k + 3.14 * potassium >= 6)
m.addConstr(4.35 * vitamin_e + 3.14 * potassium >= 16)
m.addConstr(4.63 * vitamin_b3 + 4.35 * vitamin_e >= 9)
m.addConstr(2.78 * vitamin_b5 + 3.14 * potassium >= 9)
m.addConstr(2.02 * magnesium + 3.14 * potassium >= 14)
m.addConstr(2.78 * vitamin_b5 + 2.02 * magnesium >= 13)
m.addConstr(2.78 * vitamin_b5 + 4.35 * vitamin_e >= 16)
m.addConstr(0.62 * vitamin_k + 3.14 * potassium >= 12)
m.addConstr(4.63 * vitamin_b3 + 2.02 * magnesium >= 6)

# Add constraints - Energy Stability
m.addConstr(2.15 * vitamin_b5 + 0.58 * vitamin_b3 + 3.6 * vitamin_e + 5.26 * magnesium + 2.7 * vitamin_k + 5.29 * potassium >= 16)
m.addConstr(2.15 * vitamin_b5 + 2.7 * vitamin_k >= 18)
m.addConstr(2.15 * vitamin_b5 + 0.58 * vitamin_b3 >= 15)
# ... (rest of the energy stability constraints as in the JSON)

# ... (rest of the constraints as in the JSON)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

