
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
sashimi = m.addVar(vtype=GRB.CONTINUOUS, name="sashimi")
pasta = m.addVar(vtype=GRB.INTEGER, name="bowls_of_pasta")
salad = m.addVar(vtype=GRB.INTEGER, name="bagged_salads")
beans = m.addVar(vtype=GRB.INTEGER, name="black_beans")
sandwich = m.addVar(vtype=GRB.INTEGER, name="ham_sandwiches")


# Set objective
m.setObjective(2.28*sashimi**2 + 8.55*sashimi*pasta + 9.3*sashimi*sandwich + 1.3*pasta**2 + 9.02*pasta*salad + 7.28*pasta*beans + 2.98*pasta*sandwich + 7.96*salad**2 + 5.67*salad*beans + 9.76*beans*sandwich + 9.68*salad, GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*pasta**2 + 14*beans**2 >= 56)
m.addConstr(11*sashimi + 10*pasta >= 54)
m.addConstr(10*pasta + 14*salad + 8*sandwich >= 51)
m.addConstr(11*sashimi + 14*beans + 8*sandwich >= 51)
m.addConstr(10*pasta + 14*salad + 8*sandwich >= 62)
m.addConstr(11*sashimi + 14*beans + 8*sandwich >= 62)

# ... (All other constraints as defined in the JSON "constraints" section)

m.addConstr(11 * sashimi <= 311)
m.addConstr(4 * sashimi <= 348)
m.addConstr(8 * sashimi <= 81)


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

