
import gurobipy as gp

# Create a new model
m = gp.Model("carbohydrate_optimization")

# Create variables
knishes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="knishes")
granola_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars")
fruit_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")

# Set objective function
m.setObjective(1 * knishes + 1 * granola_bars + 2 * fruit_salads, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(16 * knishes + 19 * fruit_salads >= 20, "c0")
m.addConstr(3 * granola_bars + 19 * fruit_salads >= 15, "c1")
m.addConstr(16 * knishes + 19 * fruit_salads <= 34, "c2")
m.addConstr(3 * granola_bars + 19 * fruit_salads <= 64, "c3")
m.addConstr(16 * knishes + 3 * granola_bars + 19 * fruit_salads <= 69, "c4")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('knishes:', knishes.x)
    print('granola_bars:', granola_bars.x)
    print('fruit_salads:', fruit_salads.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

