
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="knishes")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="granola_bars")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="fruit_salads")

# Set the objective function
m.setObjective(1*x1 + 1*x2 + 2*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(16*x1 + 19*x3 >= 20, "carb_knishes_fruit")
m.addConstr(3*x2 + 19*x3 >= 15, "carb_granola_fruit")
m.addConstr(16*x1 + 19*x3 <= 34, "max_carb_knishes_fruit")
m.addConstr(3*x2 + 19*x3 <= 64, "max_carb_granola_fruit")
m.addConstr(16*x1 + 3*x2 + 19*x3 <= 69, "total_max_carb")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
