
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    knishes = model.addVar(name="knishes", lb=0)
    granola_bars = model.addVar(name="granola_bars", lb=0)
    fruit_salads = model.addVar(name="fruit_salads", lb=0)

    # Define the objective function
    model.setObjective(knishes + granola_bars + 2 * fruit_salads, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(16 * knishes + 3 * granola_bars + 19 * fruit_salads <= 69)
    model.addConstr(16 * knishes + 19 * fruit_salads >= 20)
    model.addConstr(3 * granola_bars + 19 * fruit_salads >= 15)
    model.addConstr(16 * knishes + 19 * fruit_salads <= 34)
    model.addConstr(3 * granola_bars + 19 * fruit_salads <= 64)
    model.addConstr(16 * knishes + 3 * granola_bars + 19 * fruit_salads <= 64)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Knishes: {knishes.varValue}")
        print(f"Granola bars: {granola_bars.varValue}")
        print(f"Fruit salads: {fruit_salads.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
