
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, vtype=gp.GRB.INTEGER, name=["intrusion analysts", "Mbps bandwidth allocated to monitoring", "honeypots", "patches per day", "security engineers", "security onions"])


# Set objective function
m.setObjective(7*x[0] + 8*x[1] + 6*x[2] + x[3] + x[4] + x[5], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6.35*x[0] + 5.18*x[1] + 17.59*x[2] + 18.98*x[3] + 19.1*x[4] + 19.58*x[5] <= 177, "r0")
m.addConstr(13.77*x[0] + 17.34*x[1] + 13.76*x[2] + 14.43*x[3] + 5.45*x[4] + 2.72*x[5] <= 220, "r1")
m.addConstr(18.98*x[3] + 19.1*x[4] >= 9, "c1")
m.addConstr(18.98*x[3] + 19.58*x[5] >= 25, "c2")
m.addConstr(5.18*x[1] + 18.98*x[3] >= 9, "c3")
m.addConstr(17.59*x[2] + 19.58*x[5] >= 19, "c4")
m.addConstr(6.35*x[0] + 18.98*x[3] + 19.58*x[5] >= 22, "c5")
m.addConstr(13.77*x[0] + 14.43*x[3] + 2.72*x[5] >= 27, "c6")
m.addConstr(17.34*x[1] + 13.76*x[2] + 14.43*x[3] >= 27, "c7")
m.addConstr(14.43*x[3] + 5.45*x[4] + 2.72*x[5] >= 30, "c8")
m.addConstr(13.77*x[0] + 14.43*x[3] + 2.72*x[5] >= 30, "c9")
m.addConstr(13.76*x[2] + 14.43*x[3] + 5.45*x[4] >= 30, "c10")
m.addConstr(14.43*x[3] + 5.45*x[4] + 2.72*x[5] >= 25, "c11")
m.addConstr(17.34*x[1] + 13.76*x[2] + 14.43*x[3] >= 25, "c12")
m.addConstr(13.76*x[2] + 14.43*x[3] + 5.45*x[4] >= 25, "c13")
m.addConstr(13.77*x[0] + 14.43*x[3] + 2.72*x[5] >= 27, "c14")
m.addConstr(13.76*x[2] + 14.43*x[3] + 5.45*x[4] >= 27, "c15")
m.addConstr(18.98*x[3] + 19.1*x[4] <= 133, "c16")
m.addConstr(6.35*x[0] + 5.18*x[1] <= 136, "c17")
m.addConstr(5.18*x[1] + 18.98*x[3] <= 115, "c18")
m.addConstr(5.18*x[1] + 19.1*x[4] + 19.58*x[5] <= 147, "c19")
m.addConstr(17.59*x[2] + 18.98*x[3] + 19.58*x[5] <= 132, "c20")
m.addConstr(6.35*x[0] + 5.18*x[1] + 17.59*x[2] + 18.98*x[3] + 19.1*x[4] + 19.58*x[5] <= 132, "c21")
m.addConstr(13.77*x[0] + 14.43*x[3] <= 46, "c22")
m.addConstr(5.45*x[4] + 2.72*x[5] <= 216, "c23")
m.addConstr(14.43*x[3] + 2.72*x[5] <= 120, "c24")
m.addConstr(17.34*x[1] + 5.45*x[4] <= 53, "c25")
m.addConstr(13.76*x[2] + 5.45*x[4] <= 205, "c26")
m.addConstr(13.77*x[0] + 17.34*x[1] + 13.76*x[2] <= 141, "c27")
m.addConstr(13.77*x[0] + 17.34*x[1] + 13.76*x[2] + 14.43*x[3] + 5.45*x[4] + 2.72*x[5] <= 141, "c28")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
    print('Obj: %g' % m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('The problem could not be solved to optimality.')

