
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
ravioli = m.addVar(lb=0, name="ravioli")
bacon = m.addVar(lb=0, name="bacon")
knishes = m.addVar(lb=0, name="knishes")
hot_dogs = m.addVar(lb=0, name="hot_dogs")
protein_bars = m.addVar(lb=0, name="protein_bars")
strawberries = m.addVar(lb=0, name="strawberries")
green_beans = m.addVar(lb=0, name="green_beans")


# Set objective function
m.setObjective(5 * ravioli + 3 * bacon + 9 * knishes + 4 * hot_dogs + protein_bars + 4 * strawberries + 3 * green_beans, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * protein_bars + 10 * green_beans >= 29)
m.addConstr(8 * bacon + 13 * knishes >= 22)
m.addConstr(14 * strawberries + 10 * green_beans >= 27)
m.addConstr(13 * knishes + 9 * protein_bars >= 38)
m.addConstr(8 * bacon + 10 * green_beans >= 42)
m.addConstr(13 * knishes + 14 * strawberries >= 24)
m.addConstr(8 * bacon + 14 * strawberries >= 60)
m.addConstr(12 * hot_dogs + 14 * strawberries >= 27)
m.addConstr(8 * bacon + 14 * strawberries + 10 * green_beans >= 57)
m.addConstr(2 * bacon + 14 * hot_dogs >= 25)
m.addConstr(14 * knishes + 1 * strawberries >= 50)
m.addConstr(14 * knishes + 1 * green_beans >= 34)
m.addConstr(5 * ravioli + 2 * bacon >= 40)
m.addConstr(2 * bacon + 1 * green_beans >= 35)
m.addConstr(7 * protein_bars + 1 * strawberries >= 22)

# ... (rest of the constraints from the JSON, substituting variable names)

# Resource Constraints
m.addConstr(8 * ravioli + 8 * bacon + 13 * knishes + 12 * hot_dogs + 9 * protein_bars + 14 * strawberries + 10 * green_beans <= 469, "r0")
m.addConstr(5 * ravioli + 2 * bacon + 14 * knishes + 14 * hot_dogs + 7 * protein_bars + 1 * strawberries + 1 * green_beans <= 359, "r1")
m.addConstr(1 * ravioli + 5 * bacon + 6 * knishes + 12 * hot_dogs + 9 * protein_bars + 14 * strawberries + 9 * green_beans <= 395, "r2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

