
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    oranges = m.addVar(vtype=GRB.INTEGER, name="oranges")
    cheeseburgers = m.addVar(vtype=GRB.CONTINUOUS, name="cheeseburgers")

    # Set objective function
    m.setObjective(8 * oranges + 8 * cheeseburgers, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10.8 * oranges + 3.74 * cheeseburgers >= 20, "umami_index_min")
    m.addConstr(7.17 * oranges + 0.2 * cheeseburgers >= 46, "protein_min")
    m.addConstr(2 * oranges - 3 * cheeseburgers >= 0, "orange_cheeseburger_relation")
    m.addConstr(10.8 * oranges + 3.74 * cheeseburgers <= 34, "umami_index_max")
    m.addConstr(7.17 * oranges + 0.2 * cheeseburgers <= 156, "protein_max")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        print("Oranges:", oranges.x)
        print("Cheeseburgers:", cheeseburgers.x)


except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model optimized correctly.")

