
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    oranges = model.addVar(name="oranges", vtype=gurobi.GRB.INTEGER)
    cheeseburgers = model.addVar(name="cheeseburgers")

    # Set the objective function
    model.setObjective(8 * oranges + 8 * cheeseburgers, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(10.8 * oranges + 3.74 * cheeseburgers >= 20)  # minimum umami index
    model.addConstr(7.17 * oranges + 0.2 * cheeseburgers >= 46)  # minimum grams of protein
    model.addConstr(2 * oranges - 3 * cheeseburgers >= 0)  # relationship between oranges and cheeseburgers
    model.addConstr(10.8 * oranges + 3.74 * cheeseburgers <= 34)  # maximum umami index
    model.addConstr(7.17 * oranges + 0.2 * cheeseburgers <= 156)  # maximum grams of protein

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Oranges: {oranges.varValue}")
        print(f"Cheeseburgers: {cheeseburgers.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has no optimal solution.")

solve_optimization_problem()
