
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B5
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # grams of fat
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin E
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of iron


# Set objective function
m.setObjective(3*x0 + 2*x1 + 3*x2 + 2*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 6*x2 >= 42)
m.addConstr(4*x0 + 5*x3 >= 50)
m.addConstr(14*x1 + 5*x3 >= 48)
m.addConstr(4*x0 + 6*x2 >= 51)
m.addConstr(4*x0 + 6*x2 + 5*x3 >= 56)
m.addConstr(4*x0 + 14*x1 + 6*x2 >= 56)
m.addConstr(14*x1 + 6*x2 + 5*x3 >= 56)
m.addConstr(4*x0 + 14*x1 + 5*x3 >= 56)
m.addConstr(4*x0 + 6*x2 + 5*x3 >= 56) # Repeated constraint
m.addConstr(4*x0 + 14*x1 + 6*x2 >= 56) # Repeated constraint
m.addConstr(14*x1 + 6*x2 + 5*x3 >= 56) # Repeated constraint
m.addConstr(4*x0 + 14*x1 + 5*x3 >= 56) # Repeated constraint
m.addConstr(4*x0 + 6*x2 + 5*x3 >= 38)
m.addConstr(4*x0 + 14*x1 + 6*x2 >= 38)
m.addConstr(14*x1 + 6*x2 + 5*x3 >= 38)
m.addConstr(4*x0 + 14*x1 + 5*x3 >= 38)
m.addConstr(4*x0 + 6*x2 + 5*x3 >= 33)
m.addConstr(4*x0 + 14*x1 + 6*x2 >= 33)
m.addConstr(14*x1 + 6*x2 + 5*x3 >= 33)
m.addConstr(4*x0 + 14*x1 + 5*x3 >= 33)
m.addConstr(4*x0 + 14*x1 + 6*x2 + 5*x3 >= 33)
m.addConstr(2*x1 + 18*x3 >= 21)
m.addConstr(2*x1 + 16*x2 >= 15)
m.addConstr(5*x0 + 18*x3 >= 24)
m.addConstr(2*x1 + 16*x2 + 18*x3 >= 21)
m.addConstr(5*x0 + 2*x1 + 18*x3 >= 21)
m.addConstr(5*x0 + 2*x1 + 16*x2 >= 21)
m.addConstr(2*x1 + 16*x2 + 18*x3 >= 35)
m.addConstr(5*x0 + 2*x1 + 18*x3 >= 35)
m.addConstr(5*x0 + 2*x1 + 16*x2 >= 35)
m.addConstr(2*x1 + 16*x2 + 18*x3 >= 26)
m.addConstr(5*x0 + 2*x1 + 18*x3 >= 26)
m.addConstr(5*x0 + 2*x1 + 16*x2 >= 26)
m.addConstr(5*x0 + 2*x1 + 16*x2 + 18*x3 >= 26)
m.addConstr(x0 - x2 >= 0)
m.addConstr(-x0 + 5*x1 >= 0)
m.addConstr(2*x1 + 16*x2 <= 150)
m.addConstr(4*x0 + 14*x1 + 6*x2 + 5*x3 <= 257)
m.addConstr(5*x0 + 2*x1 + 16*x2 + 18*x3 <= 150)



# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("The model could not be solved to optimality.")

