
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B5
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # grams of fat
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin E
    x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY)  # milligrams of iron

    # Objective function
    model.setObjective(3*x0 + 2*x1 + 3*x2 + 2*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4*x0 <= 257)
    model.addConstr(5*x0 <= 150)
    model.addConstr(14*x1 <= 257)
    model.addConstr(2*x1 <= 150)
    model.addConstr(6*x2 <= 257)
    model.addConstr(16*x2 <= 150)
    model.addConstr(5*x3 <= 257)
    model.addConstr(18*x3 <= 150)

    model.addConstr(14*x1 + 6*x2 >= 42)
    model.addConstr(4*x0 + 5*x3 >= 50)
    model.addConstr(14*x1 + 5*x3 >= 48)
    model.addConstr(4*x0 + 6*x2 >= 51)
    model.addConstr(4*x0 + 6*x2 + 5*x3 >= 56)
    model.addConstr(4*x0 + 14*x1 + 6*x2 >= 56)
    model.addConstr(14*x1 + 6*x2 + 5*x3 >= 56)
    model.addConstr(4*x0 + 14*x1 + 5*x3 >= 56)
    model.addConstr(4*x0 + 6*x2 + 5*x3 >= 56)
    model.addConstr(4*x0 + 14*x1 + 6*x2 >= 56)
    model.addConstr(14*x1 + 6*x2 + 5*x3 >= 56)
    model.addConstr(4*x0 + 14*x1 + 5*x3 >= 56)
    model.addConstr(4*x0 + 6*x2 + 5*x3 >= 38)
    model.addConstr(4*x0 + 14*x1 + 6*x2 >= 38)
    model.addConstr(14*x1 + 6*x2 + 5*x3 >= 38)
    model.addConstr(4*x0 + 14*x1 + 5*x3 >= 38)
    model.addConstr(4*x0 + 6*x2 + 5*x3 >= 33)
    model.addConstr(4*x0 + 14*x1 + 6*x2 >= 33)
    model.addConstr(14*x1 + 6*x2 + 5*x3 >= 33)
    model.addConstr(4*x0 + 14*x1 + 5*x3 >= 33)
    model.addConstr(4*x0 + 14*x1 + 6*x2 + 5*x3 >= 33)

    model.addConstr(2*x1 + 18*x3 >= 21)
    model.addConstr(2*x1 + 16*x2 >= 15)
    model.addConstr(5*x0 + 18*x3 >= 24)
    model.addConstr(2*x1 + 16*x2 + 18*x3 >= 21)
    model.addConstr(5*x0 + 2*x1 + 18*x3 >= 21)
    model.addConstr(5*x0 + 2*x1 + 16*x2 >= 21)
    model.addConstr(2*x1 + 16*x2 + 18*x3 >= 35)
    model.addConstr(5*x0 + 2*x1 + 18*x3 >= 35)
    model.addConstr(5*x0 + 2*x1 + 16*x2 >= 35)
    model.addConstr(2*x1 + 16*x2 + 18*x3 >= 26)
    model.addConstr(5*x0 + 2*x1 + 18*x3 >= 26)
    model.addConstr(5*x0 + 2*x1 + 16*x2 >= 26)
    model.addConstr(5*x0 + 2*x1 + 16*x2 + 18*x3 >= 26)

    model.addConstr(x0 - x2 >= 0)
    model.addConstr(-x0 + 5*x1 >= 0)
    model.addConstr(2*x1 + 16*x2 <= 146)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
