
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
jean = m.addVar(lb=0, name="jean")
ringo = m.addVar(lb=0, name="ringo")
john = m.addVar(lb=0, name="john")
george = m.addVar(lb=0, name="george")


# Set objective function
m.setObjective(7.35*jean**2 + 9.5*jean*john + 5.13*jean*george + 5.59*ringo**2 + 6.13*john*george + 8.95*george**2 + 9.56*jean + 6.49*ringo + 1.6*john, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7.4*jean**2 + 3.4*george**2 >= 23)
m.addConstr(1.99*ringo + 2.67*john >= 33)
m.addConstr(7.4*jean**2 + 1.99*ringo**2 >= 20)
m.addConstr(7.4*jean**2 + 2.67*john**2 >= 20)
m.addConstr(7.4*jean + 1.99*ringo + 2.67*john + 3.4*george >= 20)
m.addConstr(1.5*john**2 + 2.16*george**2 >= 49)
m.addConstr(0.29*jean + 1.5*john >= 36)
m.addConstr(7.73*ringo + 1.5*john >= 56)
m.addConstr(7.73*ringo + 2.16*george >= 28)
m.addConstr(0.29*jean**2 + 2.16*george**2 >= 57)
m.addConstr(0.29*jean**2 + 1.5*john**2 + 2.16*george**2 >= 50)
m.addConstr(0.29*jean + 7.73*ringo + 1.5*john + 2.16*george >= 50)
m.addConstr(7*ringo - 8*george >= 0)
m.addConstr(3*jean - 7*john >= 0)
m.addConstr(7.4*jean**2 + 2.67*john**2 + 3.4*george**2 <= 209)
m.addConstr(7.73*ringo + 1.5*john <= 206)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

