
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", lb=0)  # hours worked by Jean
x2 = m.addVar(name="x2", lb=0)  # hours worked by Ringo
x3 = m.addVar(name="x3", lb=0)  # hours worked by John
x4 = m.addVar(name="x4", lb=0)  # hours worked by George

# Objective function
m.setObjective(7.35*x1**2 + 9.5*x1*x3 + 5.13*x1*x4 + 5.59*x2**2 + 6.13*x3*x4 + 8.95*x4**2 + 9.56*x1 + 6.49*x2 + 1.6*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(7.4*x1 == 7.4, name="jean_productivity")
m.addConstr(0.29*x1 == 0.29, name="jean_likelihood")
m.addConstr(1.99*x2 == 1.99, name="ringo_productivity")
m.addConstr(7.73*x2 == 7.73, name="ringo_likelihood")
m.addConstr(2.67*x3 == 2.67, name="john_productivity")
m.addConstr(1.5*x3 == 1.5, name="john_likelihood")
m.addConstr(3.4*x4 == 3.4, name="george_productivity")
m.addConstr(2.16*x4 == 2.16, name="george_likelihood")

m.addConstr(7.4**2*x1**2 + 3.4**2*x4**2 >= 23, name="productivity_rating_constraint1")
m.addConstr(1.99*x2 + 2.67*x3 >= 33, name="productivity_rating_constraint2")
m.addConstr(7.4**2*x1**2 + 1.99**2*x2**2 >= 20, name="productivity_rating_constraint3")
m.addConstr(7.4**2*x1**2 + 2.67**2*x3**2 >= 20, name="productivity_rating_constraint4")
m.addConstr(7.4*x1 + 1.99*x2 + 2.67*x3 + 3.4*x4 >= 20, name="productivity_rating_constraint5")

m.addConstr(1.5**2*x3**2 + 2.16**2*x4**2 >= 49, name="likelihood_constraint1")
m.addConstr(0.29*x1 + 1.5*x3 >= 36, name="likelihood_constraint2")
m.addConstr(7.73*x2 + 1.5*x3 >= 56, name="likelihood_constraint3")
m.addConstr(7.73*x2 + 2.16*x4 >= 28, name="likelihood_constraint4")
m.addConstr(0.29**2*x1**2 + 2.16**2*x4**2 >= 57, name="likelihood_constraint5")
m.addConstr(0.29**2*x1**2 + 1.5**2*x3**2 + 2.16**2*x4**2 >= 50, name="likelihood_constraint6")
m.addConstr(0.29*x1 + 7.73*x2 + 1.5*x3 + 2.16*x4 >= 50, name="likelihood_constraint7")

m.addConstr(7*x2 - 8*x4 >= 0, name="hours_worked_constraint1")
m.addConstr(3*x1 - 7*x3 >= 0, name="hours_worked_constraint2")

m.addConstr(7.4**2*x1**2 + 2.67**2*x3**2 + 3.4**2*x4**2 <= 209, name="productivity_rating_constraint6")
m.addConstr(7.73*x2 + 1.5*x3 <= 206, name="likelihood_constraint8")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Jean: ", x1.varValue)
    print("Hours worked by Ringo: ", x2.varValue)
    print("Hours worked by John: ", x3.varValue)
    print("Hours worked by George: ", x4.varValue)
else:
    print("The model is infeasible")
