
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    scissors = m.addVar(vtype=gp.GRB.INTEGER, name="scissors")
    paper = m.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper")
    highlighters = m.addVar(vtype=gp.GRB.INTEGER, name="red_highlighters")
    pencils = m.addVar(vtype=gp.GRB.INTEGER, name="wooden_pencils")

    # Set objective function
    m.setObjective(9*scissors + 5*paper + 3*highlighters + 8*pencils, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(18*paper + 24*highlighters >= 93)
    m.addConstr(18*paper + pencils >= 77)
    m.addConstr(32*scissors + pencils >= 46)
    m.addConstr(18*paper + 24*highlighters + pencils >= 106)
    m.addConstr(32*scissors + 18*paper + pencils >= 106)
    m.addConstr(32*scissors + 18*paper + 24*highlighters >= 106)
    m.addConstr(18*paper + 24*highlighters + pencils >= 59)
    m.addConstr(32*scissors + 18*paper + pencils >= 59)
    m.addConstr(32*scissors + 18*paper + 24*highlighters >= 59)
    m.addConstr(18*paper + 24*highlighters + pencils >= 68)
    m.addConstr(32*scissors + 18*paper + pencils >= 68)
    m.addConstr(32*scissors + 18*paper + 24*highlighters >= 68)
    m.addConstr(32*scissors + 18*paper + 24*highlighters + pencils >= 68)
    m.addConstr(-3*scissors + 7*paper >= 0)
    m.addConstr(7*scissors - pencils >= 0)
    m.addConstr(18*paper + pencils <= 363)
    m.addConstr(32*scissors + pencils <= 126)
    m.addConstr(32*scissors + 18*paper <= 283)
    m.addConstr(18*paper + 24*highlighters <= 365)
    m.addConstr(24*highlighters + pencils <= 243)
    m.addConstr(32*scissors + 18*paper + 24*highlighters <= 456)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
