
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="scissors", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="packs of paper", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="red highlighters", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="wooden pencils", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9 * x1 + 5 * x2 + 3 * x3 + 8 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(18 * x2 + 24 * x3 >= 93)
    model.addConstr(18 * x2 + x4 >= 77)
    model.addConstr(32 * x1 + x4 >= 46)
    model.addConstr(18 * x2 + 24 * x3 + x4 >= 106)
    model.addConstr(32 * x1 + 18 * x2 + x4 >= 106)
    model.addConstr(32 * x1 + 18 * x2 + 24 * x3 >= 106)
    model.addConstr(18 * x2 + 24 * x3 + x4 >= 59)
    model.addConstr(32 * x1 + 18 * x2 + x4 >= 59)
    model.addConstr(32 * x1 + 18 * x2 + 24 * x3 >= 59)
    model.addConstr(18 * x2 + 24 * x3 + x4 >= 68)
    model.addConstr(32 * x1 + 18 * x2 + x4 >= 68)
    model.addConstr(32 * x1 + 18 * x2 + 24 * x3 >= 68)
    model.addConstr(32 * x1 + 18 * x2 + 24 * x3 + x4 >= 68)
    model.addConstr(-3 * x1 + 7 * x2 >= 0)
    model.addConstr(7 * x1 - x4 >= 0)
    model.addConstr(18 * x2 + x4 <= 363)
    model.addConstr(32 * x1 + x4 <= 126)
    model.addConstr(32 * x1 + 18 * x2 <= 283)
    model.addConstr(18 * x2 + 24 * x3 <= 365)
    model.addConstr(24 * x3 + x4 <= 243)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Scissors: {x1.varValue}")
        print(f"Packs of paper: {x2.varValue}")
        print(f"Red highlighters: {x3.varValue}")
        print(f"Wooden pencils: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
