
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
eggs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="eggs")
fruit_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
kiwis = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kiwis")
apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")

# Set objective function
m.setObjective(4*eggs + 9*fruit_salads + 9*kiwis + 2*apple_pies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(28*fruit_salads + 34*kiwis >= 67)
m.addConstr(24*eggs + 28*fruit_salads + 14*apple_pies >= 44)
m.addConstr(24*eggs + 28*fruit_salads + 34*kiwis + 14*apple_pies >= 44)
m.addConstr(6*eggs + 14*fruit_salads >= 51)
m.addConstr(6*eggs + 20*kiwis >= 81)
m.addConstr(6*eggs + 14*fruit_salads + 24*apple_pies >= 58)
m.addConstr(6*eggs + 14*fruit_salads + 20*kiwis + 24*apple_pies >= 58)
m.addConstr(32*kiwis + 1*apple_pies >= 31)
m.addConstr(6*eggs + 11*fruit_salads + 1*apple_pies >= 37)
m.addConstr(11*fruit_salads + 32*kiwis + 1*apple_pies >= 37)
m.addConstr(6*eggs + 32*kiwis + 1*apple_pies >= 37)
m.addConstr(6*eggs + 11*fruit_salads + 1*apple_pies >= 48)
m.addConstr(11*fruit_salads + 32*kiwis + 1*apple_pies >= 48)
m.addConstr(6*eggs + 32*kiwis + 1*apple_pies >= 48)
m.addConstr(6*eggs + 11*fruit_salads + 1*apple_pies >= 52)
m.addConstr(11*fruit_salads + 32*kiwis + 1*apple_pies >= 52)
m.addConstr(6*eggs + 32*kiwis + 1*apple_pies >= 52)
m.addConstr(6*eggs + 11*fruit_salads + 32*kiwis + 1*apple_pies >= 52)
m.addConstr(18*eggs + 23*fruit_salads >= 42)
m.addConstr(18*eggs + 24*kiwis >= 33)
m.addConstr(24*kiwis + 26*apple_pies >= 21)
m.addConstr(18*eggs + 26*apple_pies >= 20)
m.addConstr(18*eggs + 24*kiwis + 26*apple_pies >= 29)
m.addConstr(18*eggs + 23*fruit_salads + 24*kiwis + 26*apple_pies >= 29)
m.addConstr(10*eggs - 3*apple_pies >= 0)
m.addConstr(2*eggs - 4*kiwis >= 0)
m.addConstr(28*fruit_salads + 34*kiwis <= 274)
m.addConstr(20*kiwis + 24*apple_pies <= 265)
m.addConstr(14*fruit_salads + 24*apple_pies <= 351)
m.addConstr(6*eggs + 14*fruit_salads <= 240)
m.addConstr(14*fruit_salads + 20*kiwis + 24*apple_pies <= 186)
m.addConstr(6*eggs + 14*fruit_salads + 24*apple_pies <= 253)
m.addConstr(6*eggs + 14*fruit_salads + 20*kiwis <= 283)
m.addConstr(6*eggs + 11*fruit_salads + 1*apple_pies <= 137)
m.addConstr(11*fruit_salads + 32*kiwis + 1*apple_pies <= 140)
m.addConstr(18*eggs + 26*apple_pies <= 53)
m.addConstr(18*eggs + 24*kiwis + 26*apple_pies <= 84)


# Resource Constraints
m.addConstr(24*eggs <= 347)
m.addConstr(6*eggs <= 356)
m.addConstr(6*eggs <= 213)
m.addConstr(18*eggs <= 213)
m.addConstr(28*fruit_salads <= 347)
m.addConstr(14*fruit_salads <= 356)
m.addConstr(11*fruit_salads <= 213)
m.addConstr(23*fruit_salads <= 213)
m.addConstr(34*kiwis <= 347)
m.addConstr(20*kiwis <= 356)
m.addConstr(32*kiwis <= 213)
m.addConstr(24*kiwis <= 213)
m.addConstr(14*apple_pies <= 347)
m.addConstr(24*apple_pies <= 356)
m.addConstr(1*apple_pies <= 213)
m.addConstr(26*apple_pies <= 213)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

