
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    eggs = model.addVar(name="eggs", lb=0)
    fruit_salads = model.addVar(name="fruit_salads", lb=0)
    kiwis = model.addVar(name="kiwis", lb=0)
    apple_pies = model.addVar(name="apple_pies", lb=0)

    # Objective function
    model.setObjective(4 * eggs + 9 * fruit_salads + 9 * kiwis + 2 * apple_pies, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(28 * fruit_salads + 34 * kiwis >= 67)
    model.addConstr(24 * eggs + 28 * fruit_salads + 14 * apple_pies >= 44)
    model.addConstr(24 * eggs + 28 * fruit_salads + 34 * kiwis + 14 * apple_pies >= 44)
    model.addConstr(6 * eggs + 14 * fruit_salads >= 51)
    model.addConstr(6 * eggs + 20 * kiwis >= 81)
    model.addConstr(6 * eggs + 14 * fruit_salads + 24 * apple_pies >= 58)
    model.addConstr(6 * eggs + 14 * fruit_salads + 20 * kiwis + 24 * apple_pies >= 58)
    model.addConstr(32 * kiwis + apple_pies >= 31)
    model.addConstr(6 * eggs + 11 * fruit_salads + apple_pies >= 37)
    model.addConstr(11 * fruit_salads + 32 * kiwis + apple_pies >= 37)
    model.addConstr(6 * eggs + 32 * kiwis + apple_pies >= 37)
    model.addConstr(6 * eggs + 11 * fruit_salads + apple_pies >= 48)
    model.addConstr(11 * fruit_salads + 32 * kiwis + apple_pies >= 48)
    model.addConstr(6 * eggs + 32 * kiwis + apple_pies >= 48)
    model.addConstr(6 * eggs + 11 * fruit_salads + apple_pies >= 52)
    model.addConstr(11 * fruit_salads + 32 * kiwis + apple_pies >= 52)
    model.addConstr(6 * eggs + 32 * kiwis + apple_pies >= 52)
    model.addConstr(6 * eggs + 11 * fruit_salads + 32 * kiwis + apple_pies >= 52)
    model.addConstr(18 * eggs + 23 * fruit_salads >= 42)
    model.addConstr(18 * eggs + 24 * kiwis >= 33)
    model.addConstr(24 * kiwis + 26 * apple_pies >= 21)
    model.addConstr(18 * eggs + 26 * apple_pies >= 20)
    model.addConstr(18 * eggs + 24 * kiwis + 26 * apple_pies >= 29)
    model.addConstr(18 * eggs + 23 * fruit_salads + 24 * kiwis + 26 * apple_pies >= 29)
    model.addConstr(10 * eggs - 3 * apple_pies >= 0)
    model.addConstr(2 * eggs - 4 * kiwis >= 0)
    model.addConstr(28 * fruit_salads + 34 * kiwis <= 274)
    model.addConstr(20 * kiwis + 24 * apple_pies <= 265)
    model.addConstr(14 * fruit_salads + 24 * apple_pies <= 351)
    model.addConstr(6 * eggs + 14 * fruit_salads <= 240)
    model.addConstr(14 * fruit_salads + 20 * kiwis + 24 * apple_pies <= 186)
    model.addConstr(6 * eggs + 14 * fruit_salads + 24 * apple_pies <= 253)
    model.addConstr(6 * eggs + 14 * fruit_salads + 20 * kiwis <= 283)
    model.addConstr(6 * eggs + 11 * fruit_salads + apple_pies <= 137)
    model.addConstr(11 * fruit_salads + 32 * kiwis + apple_pies <= 140)
    model.addConstr(18 * eggs + 26 * apple_pies <= 53)
    model.addConstr(18 * eggs + 24 * kiwis + 26 * apple_pies <= 84)
    model.addConstr(24 * eggs + 28 * fruit_salads + 34 * kiwis + 14 * apple_pies <= 347)
    model.addConstr(6 * eggs + 14 * fruit_salads + 20 * kiwis + 24 * apple_pies <= 356)
    model.addConstr(6 * eggs + 11 * fruit_salads + 32 * kiwis + apple_pies <= 213)
    model.addConstr(18 * eggs + 23 * fruit_salads + 24 * kiwis + 26 * apple_pies <= 213)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Eggs: ", eggs.varValue)
        print("Fruit Salads: ", fruit_salads.varValue)
        print("Kiwis: ", kiwis.varValue)
        print("Apple Pies: ", apple_pies.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
