
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
george_hours = m.addVar(vtype=gp.GRB.INTEGER, name="george_hours")
john_hours = m.addVar(name="john_hours")
mary_hours = m.addVar(name="mary_hours")
bobby_hours = m.addVar(name="bobby_hours")

# Set objective function
m.setObjective(8.77 * george_hours + 6.24 * john_hours + 4.31 * mary_hours + 8.4 * bobby_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * john_hours + 8 * mary_hours >= 60)
m.addConstr(5 * george_hours + 8 * mary_hours >= 73)
m.addConstr(5 * john_hours + 10 * bobby_hours >= 61)
m.addConstr(8 * mary_hours + 10 * bobby_hours >= 58)
m.addConstr(5 * george_hours + 10 * bobby_hours >= 65)
m.addConstr(5 * george_hours + 5 * john_hours + 8 * mary_hours + 10 * bobby_hours >= 65)
m.addConstr(14 * john_hours + 13 * bobby_hours >= 48)
m.addConstr(8 * mary_hours + 13 * bobby_hours >= 62)
m.addConstr(10 * george_hours + 13 * bobby_hours >= 29)
m.addConstr(14 * john_hours + 8 * mary_hours >= 63)
m.addConstr(10 * george_hours + 8 * mary_hours + 13 * bobby_hours >= 57)
m.addConstr(10 * george_hours + 14 * john_hours + 8 * mary_hours >= 57)
m.addConstr(10 * george_hours + 8 * mary_hours + 13 * bobby_hours >= 51)
m.addConstr(10 * george_hours + 14 * john_hours + 8 * mary_hours >= 51)
m.addConstr(10 * george_hours + 14 * john_hours + 8 * mary_hours + 13 * bobby_hours >= 51)
m.addConstr(11 * john_hours + 6 * bobby_hours >= 42)
m.addConstr(7 * mary_hours + 6 * bobby_hours >= 42)
m.addConstr(4 * george_hours + 11 * john_hours >= 25)
m.addConstr(4 * george_hours + 7 * mary_hours >= 42)
m.addConstr(11 * john_hours + 7 * mary_hours + 6 * bobby_hours >= 54)
m.addConstr(4 * george_hours + 7 * mary_hours + 6 * bobby_hours >= 54)
m.addConstr(11 * john_hours + 7 * mary_hours + 6 * bobby_hours >= 56)
m.addConstr(4 * george_hours + 7 * mary_hours + 6 * bobby_hours >= 56)
m.addConstr(4 * george_hours + 11 * john_hours + 7 * mary_hours + 6 * bobby_hours >= 56)
m.addConstr(12 * john_hours + 1 * mary_hours >= 44)
m.addConstr(9 * george_hours + 1 * mary_hours >= 65)
m.addConstr(1 * mary_hours + 14 * bobby_hours >= 51)
m.addConstr(9 * george_hours + 1 * mary_hours + 14 * bobby_hours >= 40)
m.addConstr(12 * john_hours + 1 * mary_hours + 14 * bobby_hours >= 40)
m.addConstr(9 * george_hours + 1 * mary_hours + 14 * bobby_hours >= 70)
m.addConstr(12 * john_hours + 1 * mary_hours + 14 * bobby_hours >= 70)
m.addConstr(9 * george_hours + 12 * john_hours + 1 * mary_hours + 14 * bobby_hours >= 70)
m.addConstr(2 * john_hours - 4 * mary_hours >= 0)
m.addConstr(5 * john_hours + 10 * bobby_hours <= 137)
m.addConstr(14 * john_hours + 13 * bobby_hours <= 250)
m.addConstr(4 * george_hours + 7 * mary_hours <= 173)
m.addConstr(4 * george_hours + 6 * bobby_hours <= 207)
m.addConstr(11 * john_hours + 7 * mary_hours + 6 * bobby_hours <= 86)
m.addConstr(4 * george_hours + 11 * john_hours + 7 * mary_hours <= 177)
m.addConstr(4 * george_hours + 11 * john_hours + 6 * bobby_hours <= 110)
m.addConstr(1 * mary_hours + 14 * bobby_hours <= 183)
m.addConstr(9 * george_hours + 12 * john_hours + 1 * mary_hours <= 102)
m.addConstr(9 * george_hours + 12 * john_hours + 14 * bobby_hours <= 89)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
