
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    hamburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hamburgers")
    pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")
    lemons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")


    # Set objective function
    m.setObjective(8.01 * hamburgers + 3.71 * pickles + 4.87 * lemons, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12 * hamburgers + 7 * lemons >= 17, "c1")
    m.addConstr(19 * pickles + 7 * lemons >= 18, "c2")
    m.addConstr(12 * hamburgers + 19 * pickles >= 10, "c3")
    m.addConstr(18 * hamburgers + 17 * pickles + 19 * lemons >= 68, "c4")
    m.addConstr(12 * hamburgers + 19 * pickles <= 56, "c5")
    m.addConstr(19 * pickles + 7 * lemons <= 53, "c6")
    m.addConstr(12 * hamburgers + 19 * pickles + 7 * lemons <= 53, "c7")
    m.addConstr(17 * pickles + 19 * lemons <= 110, "c8")
    m.addConstr(18 * hamburgers + 19 * lemons <= 106, "c9")
    m.addConstr(18 * hamburgers + 17 * pickles + 19 * lemons <= 71, "c10")
    m.addConstr(18 * hamburgers + 17 * pickles + 19 * lemons <= 71, "c11")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
