
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hamburgers", lb=0)
x1 = m.addVar(name="pickles", lb=0)
x2 = m.addVar(name="lemons", lb=0)

# Define the objective function
m.setObjective(8.01*x0 + 3.71*x1 + 4.87*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x0 + 7*x2 >= 17)
m.addConstr(19*x1 + 7*x2 >= 18)
m.addConstr(12*x0 + 19*x1 >= 10)
m.addConstr(18*x0 + 17*x1 + 19*x2 >= 68)
m.addConstr(12*x0 + 19*x1 <= 56)
m.addConstr(19*x1 + 7*x2 <= 53)
m.addConstr(12*x0 + 19*x1 + 7*x2 <= 84)
m.addConstr(17*x1 + 19*x2 <= 110)
m.addConstr(18*x0 + 19*x2 <= 106)
m.addConstr(18*x0 + 17*x1 + 19*x2 <= 71)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hamburgers: {x0.varValue}")
    print(f"Pickles: {x1.varValue}")
    print(f"Lemons: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
