
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, lb=0, vtype=GRB.INTEGER, name=["Bobby", "Hank", "Dale", "Paul", "George", "Mary"])


# Set objective function
obj = 3*x[0]**2 + x[0]*x[1] + 9*x[0]*x[2] + 4*x[0]*x[3] + 6*x[0]*x[4] + 4*x[0]*x[5] + 7*x[1]**2 + 4*x[1]*x[2] + 6*x[1]*x[3] + x[2]*x[3] + 5*x[2]*x[4] + x[3]**2 + 9*x[3]*x[4] + 2*x[3]*x[5] + 5*x[4]**2 + x[4]*x[5] + 3*x[5]**2 + 8*x[2] + 3*x[3] + 9*x[4] + 8*x[5]

m.setObjective(obj, GRB.MAXIMIZE)

# Resource coefficients
resource_coeffs = {
    'r0': {'x0': 2, 'x1': 6, 'x2': 8, 'x3': 12, 'x4': 3, 'x5': 3},
    'r1': {'x0': 7, 'x1': 16, 'x2': 13, 'x3': 8, 'x4': 10, 'x5': 10},
    'r2': {'x0': 13, 'x1': 17, 'x2': 7, 'x3': 3, 'x4': 15, 'x5': 13}
}

resource_bounds = {
    'r0': 461,
    'r1': 187,
    'r2': 392
}

# Add resource constraints
for r, coeffs in resource_coeffs.items():
    m.addConstr(gp.quicksum(coeffs[f'x{i}'] * x[i] for i in range(6)) <= resource_bounds[r], name=f'{r}_constraint')


# Add other constraints (simplified example - replace with your actual constraints)
m.addConstr(2*x[0] + 6*x[1] >= 60)
m.addConstr(6*x[1] + 12*x[3] >= 42)
# ... add all other constraints similarly


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")

