
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x = m.add_vars(6, vtype=gp.GRB.INTEGER)

# Set variable names for clarity
m.setParam("VarNames", 1)
x[0].setAttr("Name", "hours_worked_by_Bobby")
x[1].setAttr("Name", "hours_worked_by_Hank")
x[2].setAttr("Name", "hours_worked_by_Dale")
x[3].setAttr("Name", "hours_worked_by_Paul")
x[4].setAttr("Name", "hours_worked_by_George")
x[5].setAttr("Name", "hours_worked_by_Mary")

# Objective function
m.setObjective(3*x[0]**2 + x[0]*x[1] + 9*x[0]*x[2] + 4*x[0]*x[3] + 6*x[0]*x[4] + 4*x[0]*x[5] + 
               7*x[1]**2 + 4*x[1]*x[2] + 6*x[1]*x[3] + x[1]*x[4] + 5*x[2]*x[4] + x[3]**2 + 
               9*x[3]*x[4] + 2*x[3]*x[5] + 5*x[4]**2 + x[4]*x[5] + 3*x[5]**2 + 8*x[2] + 3*x[3] + 
               9*x[4] + 8*x[5], gp.GRB.MAXIMIZE)

# Constraints
# Work quality ratings
m.addConstr(2*x[0] <= 461)
m.addConstr(6*x[1] <= 461)
m.addConstr(8*x[2] <= 461)
m.addConstr(12*x[3] <= 461)
m.addConstr(3*x[4] <= 461)
m.addConstr(3*x[5] <= 461)

# Computer competence ratings
m.addConstr(7*x[0] <= 187)
m.addConstr(16*x[1] <= 187)
m.addConstr(13*x[2] <= 187)
m.addConstr(8*x[3] <= 187)
m.addConstr(10*x[4] <= 187)
m.addConstr(10*x[5] <= 187)

# Paperwork competence ratings
m.addConstr(13*x[0] <= 392)
m.addConstr(17*x[1] <= 392)
m.addConstr(7*x[2] <= 392)
m.addConstr(3*x[3] <= 392)
m.addConstr(15*x[4] <= 392)
m.addConstr(13*x[5] <= 392)

# Other constraints...
m.addConstr(2*x[0] + 6*x[1] >= 60)

# Integrality constraints
for i in range(6):
    m.addConstr(x[i] >= 0)
    m.addConstr(x[i] % 1 == 0)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    for i in range(6):
        print(x[i].varName, ":", x[i].x)
else:
    print("No optimal solution found")
