
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="potatoes", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="rotisserie_chickens", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="corn_cobs", vtype=gurobi.GRB.CONTINUOUS)
    
    # Objective function
    model.setObjective(6.51*x1**2 + 6.3*x1*x2 + 8.57*x2**2 + 3.48*x2*x3 + 7.18*x3**2 + 4.64*x2 + 3.49*x3, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(-x2 + 10*x3 >= 0, name="constraint_1")
    model.addConstr(5.32*x1 + 0.57*x3 <= 47, name="constraint_2")
    model.addConstr((5.14)**2*x2**2 + (0.57)**2*x3**2 <= 67, name="constraint_3")
    model.addConstr((5.32)**2*x1**2 + (5.14)**2*x2**2 <= 74, name="constraint_4")
    model.addConstr(5.32*x1 + 5.14*x2 + 0.57*x3 <= 74, name="constraint_5")
    
    # Optimize
    model.optimize()
    
    # Print solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Potatoes: ", x1.varValue)
        print("Rotisserie Chickens: ", x2.varValue)
        print("Corn Cobs: ", x3.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
