
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    bill_hours = model.addVar(vtype=GRB.INTEGER, name="bill_hours")
    john_hours = model.addVar(vtype=GRB.CONTINUOUS, name="john_hours")

    # Set objective function
    model.setObjective(5.02*bill_hours**2 + 4.37*bill_hours*john_hours + 3.47*john_hours**2 + 3.78*john_hours, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(8*bill_hours + 13*john_hours <= 132, "r0_constraint")
    model.addConstr(2*bill_hours + 9*john_hours <= 130, "r1_constraint")
    model.addConstr(6*bill_hours + 12*john_hours <= 123, "r2_constraint")
    model.addConstr(bill_hours**2 + john_hours**2 >= 35, "c1")
    model.addConstr(2*bill_hours + 9*john_hours >= 41, "c2")
    model.addConstr(6*bill_hours + 12*john_hours >= 38, "c3")
    model.addConstr(3*bill_hours - 6*john_hours >= 0, "c4")
    model.addConstr(bill_hours**2 + john_hours**2 <= 123, "c5")
    model.addConstr(8*bill_hours + 13*john_hours <= 123, "c6")
    model.addConstr(2*bill_hours**2 + 9*john_hours**2 <= 80, "c7")
    model.addConstr(2*bill_hours + 9*john_hours <= 80, "c8")
    model.addConstr(6*bill_hours + 12*john_hours <= 71, "c9")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Bill Hours: %g' % bill_hours.x)
        print('John Hours: %g' % john_hours.x)
    elif model.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
