
import gurobi as gp
from gurobi import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Bill", vtype=GRB.INTEGER)  # Bill's hours
x2 = m.addVar(name="hours_worked_by_John")  # John's hours

# Define the objective function
m.setObjective(5.02*x1**2 + 4.37*x1*x2 + 3.47*x2**2 + 3.78*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x1**2 + 13*x2**2 >= 35, name="dollar_cost_constraint")
m.addConstr(2*x1 + 9*x2 >= 41, name="work_quality_constraint")
m.addConstr(6*x1 + 12*x2 >= 38, name="likelihood_to_quit_constraint")
m.addConstr(3*x1 - 6*x2 >= 0, name="hours_worked_constraint")
m.addConstr(8*x1**2 + 13*x2**2 <= 123, name="dollar_cost_upper_bound")
m.addConstr(8*x1 + 13*x2 <= 123, name="total_dollar_cost")
m.addConstr(2*x1**2 + 9*x2**2 <= 80, name="work_quality_upper_bound")
m.addConstr(2*x1 + 9*x2 <= 80, name="total_work_quality")
m.addConstr(6*x1 + 12*x2 <= 71, name="total_likelihood_to_quit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", x1.varValue)
    print("Hours worked by John: ", x2.varValue)
else:
    print("The model is infeasible")
