
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
lanyards = model.addVar(vtype=GRB.INTEGER, name="lanyards")
mechanical_pencils = model.addVar(vtype=GRB.INTEGER, name="mechanical_pencils")
red_pens = model.addVar(vtype=GRB.INTEGER, name="red_pens")
blue_pens = model.addVar(vtype=GRB.INTEGER, name="blue_pens")
monochrome_printers = model.addVar(vtype=GRB.INTEGER, name="monochrome_printers")
packs_of_paper = model.addVar(vtype=GRB.INTEGER, name="packs_of_paper")
black_pens = model.addVar(vtype=GRB.INTEGER, name="black_pens")


# Set objective function
model.setObjective(4*lanyards + 5*mechanical_pencils + 5*red_pens + 6*blue_pens + 3*monochrome_printers + 7*packs_of_paper + 4*black_pens, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6*lanyards + 9*mechanical_pencils >= 15)
model.addConstr(9*red_pens + 10*blue_pens >= 16)
model.addConstr(9*mechanical_pencils + 7*black_pens >= 25)
model.addConstr(6*lanyards + 15*packs_of_paper >= 12)
model.addConstr(9*mechanical_pencils + 9*red_pens >= 23)
model.addConstr(15*packs_of_paper + 7*black_pens >= 14)
model.addConstr(6*lanyards + 7*black_pens >= 25)
model.addConstr(10*blue_pens + 4*monochrome_printers >= 12)
model.addConstr(9*red_pens + 15*packs_of_paper >= 10)
model.addConstr(6*lanyards + 10*blue_pens >= 16)
model.addConstr(9*mechanical_pencils + 4*monochrome_printers >= 10)
model.addConstr(4*monochrome_printers + 15*packs_of_paper >= 17)
model.addConstr(10*blue_pens + 15*packs_of_paper >= 19)
model.addConstr(4*monochrome_printers + 7*black_pens >= 12)
model.addConstr(9*red_pens + 10*blue_pens + 15*packs_of_paper >= 25)
model.addConstr(9*red_pens + 4*monochrome_printers + 7*black_pens >= 25)
model.addConstr(6*lanyards + 4*monochrome_printers + 7*black_pens >= 25)
model.addConstr(6*lanyards + 9*mechanical_pencils + 15*packs_of_paper >= 25)
model.addConstr(9*red_pens + 10*blue_pens + 15*packs_of_paper >= 22)
model.addConstr(9*red_pens + 4*monochrome_printers + 7*black_pens >= 22)
model.addConstr(6*lanyards + 4*monochrome_printers + 7*black_pens >= 22)
model.addConstr(6*lanyards + 9*mechanical_pencils + 15*packs_of_paper >= 22)
model.addConstr(9*red_pens + 10*blue_pens + 15*packs_of_paper >= 13)
model.addConstr(9*red_pens + 4*monochrome_printers + 7*black_pens >= 13)
model.addConstr(6*lanyards + 4*monochrome_printers + 7*black_pens >= 13)
model.addConstr(6*lanyards + 9*mechanical_pencils + 15*packs_of_paper >= 13)
model.addConstr(9*red_pens + 10*blue_pens + 15*packs_of_paper >= 16)
model.addConstr(9*red_pens + 4*monochrome_printers + 7*black_pens >= 16)
model.addConstr(6*lanyards + 4*monochrome_printers + 7*black_pens >= 16)
model.addConstr(6*lanyards + 9*mechanical_pencils + 15*packs_of_paper >= 16)
model.addConstr(-4*blue_pens + 10*black_pens >= 0)
model.addConstr(6*lanyards + 4*monochrome_printers <= 40)
model.addConstr(9*mechanical_pencils + 10*blue_pens <= 136)
model.addConstr(4*monochrome_printers + 15*packs_of_paper <= 34)
model.addConstr(6*lanyards + 10*blue_pens <= 52)
model.addConstr(9*red_pens + 7*black_pens <= 141)
model.addConstr(15*packs_of_paper + 7*black_pens <= 108)
model.addConstr(9*red_pens + 4*monochrome_printers <= 104)
model.addConstr(9*mechanical_pencils + 9*red_pens <= 53)
model.addConstr(9*red_pens + 15*packs_of_paper <= 64)
model.addConstr(9*mechanical_pencils + 15*packs_of_paper <= 158)
model.addConstr(4*monochrome_printers + 7*black_pens <= 61)
model.addConstr(10*blue_pens + 15*packs_of_paper <= 35)
model.addConstr(6*lanyards + 15*packs_of_paper <= 116)
model.addConstr(6*lanyards + 4*monochrome_printers + 15*packs_of_paper <= 120)
model.addConstr(6*lanyards + 9*mechanical_pencils + 9*red_pens + 10*blue_pens + 4*monochrome_printers + 15*packs_of_paper + 7*black_pens <= 175)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

