
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="lanyards", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="mechanical_pencils", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="red_pens", vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name="blue_pens", vtype=gurobi.GRB.INTEGER)
x5 = m.addVar(name="monochrome_printers", vtype=gurobi.GRB.INTEGER)
x6 = m.addVar(name="packs_of_paper", vtype=gurobi.GRB.INTEGER)
x7 = m.addVar(name="black_pens", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(4*x1 + 5*x2 + 5*x3 + 6*x4 + 3*x5 + 7*x6 + 4*x7, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x1 + 9*x2 + 9*x3 + 10*x4 + 4*x5 + 15*x6 + 7*x7 <= 175)
m.addConstr(6*x1 + 9*x2 >= 15)
m.addConstr(9*x3 + 10*x4 >= 16)
m.addConstr(9*x2 + 7*x7 >= 25)
m.addConstr(6*x1 + 15*x6 >= 12)
m.addConstr(9*x2 + 9*x3 >= 23)
m.addConstr(15*x6 + 7*x7 >= 14)
m.addConstr(6*x1 + 7*x7 >= 25)
m.addConstr(10*x4 + 4*x5 >= 12)
m.addConstr(9*x3 + 15*x6 >= 10)
m.addConstr(6*x1 + 10*x4 >= 16)
m.addConstr(9*x2 + 4*x5 >= 10)
m.addConstr(4*x5 + 15*x6 >= 17)
m.addConstr(10*x4 + 15*x6 >= 19)
m.addConstr(4*x5 + 7*x7 >= 12)
m.addConstr(9*x3 + 10*x4 + 15*x6 >= 25)
m.addConstr(9*x3 + 4*x5 + 7*x7 >= 25)
m.addConstr(6*x1 + 4*x5 + 7*x7 >= 25)
m.addConstr(6*x1 + 9*x2 + 15*x6 >= 25)
m.addConstr(9*x3 + 10*x4 + 15*x6 >= 22)
m.addConstr(9*x3 + 4*x5 + 7*x7 >= 22)
m.addConstr(6*x1 + 4*x5 + 7*x7 >= 22)
m.addConstr(6*x1 + 9*x2 + 15*x6 >= 22)
m.addConstr(9*x3 + 10*x4 + 15*x6 >= 13)
m.addConstr(9*x3 + 4*x5 + 7*x7 >= 13)
m.addConstr(6*x1 + 4*x5 + 7*x7 >= 13)
m.addConstr(6*x1 + 9*x2 + 15*x6 >= 13)
m.addConstr(9*x3 + 10*x4 + 15*x6 >= 16)
m.addConstr(9*x3 + 4*x5 + 7*x7 >= 16)
m.addConstr(6*x1 + 4*x5 + 7*x7 >= 16)
m.addConstr(6*x1 + 9*x2 + 15*x6 >= 16)
m.addConstr(-4*x4 + 10*x7 >= 0)
m.addConstr(6*x1 + 4*x5 <= 40)
m.addConstr(9*x2 + 10*x4 <= 136)
m.addConstr(4*x5 + 15*x6 <= 34)
m.addConstr(6*x1 + 10*x4 <= 52)
m.addConstr(9*x3 + 7*x7 <= 141)
m.addConstr(15*x6 + 7*x7 <= 108)
m.addConstr(9*x3 + 4*x5 <= 104)
m.addConstr(9*x2 + 9*x3 <= 53)
m.addConstr(9*x3 + 15*x6 <= 64)
m.addConstr(9*x2 + 15*x6 <= 158)
m.addConstr(4*x5 + 7*x7 <= 61)
m.addConstr(10*x4 + 15*x6 <= 35)
m.addConstr(6*x1 + 15*x6 <= 116)
m.addConstr(6*x1 + 4*x5 + 15*x6 <= 120)
m.addConstr(6*x1 + 9*x2 + 9*x3 + 10*x4 + 4*x5 + 15*x6 + 7*x7 <= 120)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("lanyards: ", x1.varValue)
    print("mechanical_pencils: ", x2.varValue)
    print("red_pens: ", x3.varValue)
    print("blue_pens: ", x4.varValue)
    print("monochrome_printers: ", x5.varValue)
    print("packs_of_paper: ", x6.varValue)
    print("black_pens: ", x7.varValue)
else:
    print("The model is infeasible")
