
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    lanyards = m.addVar(vtype=gp.GRB.INTEGER, name="lanyards")
    scissors = m.addVar(vtype=gp.GRB.INTEGER, name="scissors")
    red_highlighters = m.addVar(vtype=gp.GRB.INTEGER, name="red_highlighters")
    manila_envelopes = m.addVar(vtype=gp.GRB.INTEGER, name="manila_envelopes")

    # Set objective function
    m.setObjective(5.87 * lanyards + 8.98 * scissors + 1.13 * red_highlighters + 9.47 * manila_envelopes, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4 * lanyards + 30 * scissors + 27 * red_highlighters + 24 * manila_envelopes <= 782, "c0")
    m.addConstr(24 * lanyards + 28 * scissors + 10 * red_highlighters + 4 * manila_envelopes <= 401, "c1")
    m.addConstr(25 * lanyards + 10 * scissors + 7 * red_highlighters + 21 * manila_envelopes <= 315, "c2")
    m.addConstr(27 * red_highlighters + 24 * manila_envelopes >= 81, "c3")
    m.addConstr(4 * lanyards + 27 * red_highlighters >= 94, "c4")
    m.addConstr(30 * scissors + 24 * manila_envelopes >= 141, "c5")
    m.addConstr(4 * lanyards + 27 * red_highlighters + 24 * manila_envelopes >= 192, "c6")
    m.addConstr(30 * scissors + 27 * red_highlighters + 24 * manila_envelopes >= 192, "c7")
    m.addConstr(4 * lanyards + 27 * red_highlighters + 24 * manila_envelopes >= 155, "c8")
    m.addConstr(30 * scissors + 27 * red_highlighters + 24 * manila_envelopes >= 155, "c9")
    m.addConstr(4 * lanyards + 30 * scissors + 27 * red_highlighters + 24 * manila_envelopes >= 155, "c10")
    m.addConstr(10 * red_highlighters + 4 * manila_envelopes >= 53, "c11")
    m.addConstr(28 * scissors + 10 * red_highlighters >= 40, "c12")
    m.addConstr(24 * lanyards + 10 * red_highlighters >= 37, "c13")
    m.addConstr(24 * lanyards + 4 * manila_envelopes >= 33, "c14")
    m.addConstr(28 * scissors + 4 * manila_envelopes >= 87, "c15")
    m.addConstr(24 * lanyards + 10 * red_highlighters + 4 * manila_envelopes >= 63, "c16")
    m.addConstr(24 * lanyards + 28 * scissors + 10 * red_highlighters + 4 * manila_envelopes >= 63, "c17")
    m.addConstr(7 * red_highlighters + 21 * manila_envelopes >= 27, "c18")
    m.addConstr(25 * lanyards + 21 * manila_envelopes >= 53, "c19")
    m.addConstr(25 * lanyards + 7 * red_highlighters >= 36, "c20")
    m.addConstr(10 * scissors + 7 * red_highlighters >= 39, "c21")
    m.addConstr(25 * lanyards + 10 * scissors >= 49, "c22")
    m.addConstr(25 * lanyards + 10 * scissors + 7 * red_highlighters + 21 * manila_envelopes >= 49, "c23")
    m.addConstr(6 * scissors - 9 * red_highlighters >= 0, "c24")
    m.addConstr(-10 * red_highlighters + 5 * manila_envelopes >= 0, "c25")
    m.addConstr(25 * lanyards + 10 * scissors + 21 * manila_envelopes <= 109, "c26")
    m.addConstr(25 * lanyards + 7 * red_highlighters + 21 * manila_envelopes <= 151, "c27")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
