
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # lanyards
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # scissors
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # red highlighters
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # manila envelopes

    # Objective function
    model.setObjective(5.87 * x0 + 8.98 * x1 + 1.13 * x2 + 9.47 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x0 + 30 * x1 + 27 * x2 + 24 * x3 <= 782)
    model.addConstr(24 * x0 + 28 * x1 + 10 * x2 + 4 * x3 <= 401)
    model.addConstr(25 * x0 + 10 * x1 + 7 * x2 + 21 * x3 <= 315)
    model.addConstr(27 * x2 + 24 * x3 >= 81)
    model.addConstr(4 * x0 + 27 * x2 >= 94)
    model.addConstr(30 * x1 + 24 * x3 >= 141)
    model.addConstr(4 * x0 + 27 * x2 + 24 * x3 >= 192)
    model.addConstr(30 * x1 + 27 * x2 + 24 * x3 >= 192)
    model.addConstr(4 * x0 + 27 * x2 + 24 * x3 >= 155)
    model.addConstr(30 * x1 + 27 * x2 + 24 * x3 >= 155)
    model.addConstr(4 * x0 + 30 * x1 + 27 * x2 + 24 * x3 >= 155)
    model.addConstr(10 * x2 + 4 * x3 >= 53)
    model.addConstr(28 * x1 + 10 * x2 >= 40)
    model.addConstr(24 * x0 + 10 * x2 >= 37)
    model.addConstr(24 * x0 + 4 * x3 >= 33)
    model.addConstr(28 * x1 + 4 * x3 >= 87)
    model.addConstr(24 * x0 + 10 * x2 + 4 * x3 >= 63)
    model.addConstr(24 * x0 + 28 * x1 + 10 * x2 + 4 * x3 >= 63)
    model.addConstr(7 * x2 + 21 * x3 >= 27)
    model.addConstr(25 * x0 + 21 * x3 >= 53)
    model.addConstr(25 * x0 + 7 * x2 >= 36)
    model.addConstr(10 * x1 + 7 * x2 >= 39)
    model.addConstr(25 * x0 + 10 * x1 + 7 * x2 + 21 * x3 >= 49)
    model.addConstr(6 * x1 - 9 * x2 >= 0)
    model.addConstr(-10 * x2 + 5 * x3 >= 0)
    model.addConstr(25 * x0 + 10 * x1 + 21 * x3 <= 109)
    model.addConstr(25 * x0 + 7 * x2 + 21 * x3 <= 151)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0 (lanyards): ", x0.varValue)
        print("x1 (scissors): ", x1.varValue)
        print("x2 (red highlighters): ", x2.varValue)
        print("x3 (manila envelopes): ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
