
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="water_purification_units", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="transportation_companies", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9*x1**2 + 3*x1 + 8*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(17*x1 + 4*x2 <= 120)
    model.addConstr(16*x1 + 18*x2 >= 25)
    model.addConstr(-x1 + 8*x2 >= 0)
    model.addConstr((17*x1)**2 + (4*x2)**2 >= 25)
    model.addConstr((17*x1)**2 + (4*x2)**2 <= 93)
    model.addConstr(17*x1 + 4*x2 <= 93)
    model.addConstr(16*x1 + 18*x2 <= 91)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Water purification units: {x1.varValue}")
        print(f"Transportation companies: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
