
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
hank_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")
paul_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")
peggy_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")


# Set objective function
model.setObjective(4.64 * laura_hours + 3.55 * hank_hours + 9.46 * paul_hours + 7.42 * peggy_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(17 * laura_hours + 5 * hank_hours + 26 * paul_hours + 6 * peggy_hours <= 250, "r0")
model.addConstr(5 * hank_hours + 6 * peggy_hours <= 210, "c1")
model.addConstr(26 * paul_hours + 6 * peggy_hours <= 210, "c2")
model.addConstr(17 * laura_hours + 26 * paul_hours <= 142, "c3")
model.addConstr(17 * laura_hours + 6 * peggy_hours <= 232, "c4")
model.addConstr(17 * laura_hours + 5 * hank_hours + 26 * paul_hours + 6 * peggy_hours <= 232, "c5")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print("Variable values:")
    print(f"  Laura's hours: {laura_hours.x}")
    print(f"  Hank's hours: {hank_hours.x}")
    print(f"  Paul's hours: {paul_hours.x}")
    print(f"  Peggy's hours: {peggy_hours.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

