
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="hours_worked_by_Laura")
x2 = m.addVar(lb=0, name="hours_worked_by_Hank")
x3 = m.addVar(lb=0, name="hours_worked_by_Paul")
x4 = m.addVar(lb=0, name="hours_worked_by_Peggy")

# Define the objective function
m.setObjective(4.64*x1 + 3.55*x2 + 9.46*x3 + 7.42*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x2 + 6*x4 <= 210)
m.addConstr(26*x3 + 6*x4 <= 210)
m.addConstr(17*x1 + 26*x3 <= 142)
m.addConstr(17*x1 + 6*x4 <= 232)
m.addConstr(17*x1 + 5*x2 + 26*x3 + 6*x4 <= 250)

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Laura: {x1.x}")
    print(f"Hours worked by Hank: {x2.x}")
    print(f"Hours worked by Paul: {x3.x}")
    print(f"Hours worked by Peggy: {x4.x}")
else:
    print("No optimal solution found")
