
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Laura", lb=0)
x2 = m.addVar(name="hours_worked_by_Hank", lb=0)
x3 = m.addVar(name="hours_worked_by_Paul", lb=0)
x4 = m.addVar(name="hours_worked_by_Peggy", lb=0)

# Define the objective function
m.setObjective(4.64*x1 + 3.55*x2 + 9.46*x3 + 7.42*x4, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(17*x1 <= 250, name="Laura_paperwork")
m.addConstr(5*x2 <= 250, name="Hank_paperwork")
m.addConstr(26*x3 <= 250, name="Paul_paperwork")
m.addConstr(6*x4 <= 250, name="Peggy_paperwork")
m.addConstr(5*x2 + 6*x4 <= 210, name="Hank_Peggy_paperwork")
m.addConstr(26*x3 + 6*x4 <= 210, name="Paul_Peggy_paperwork")
m.addConstr(17*x1 + 26*x3 <= 142, name="Laura_Paul_paperwork")
m.addConstr(17*x1 + 6*x4 <= 232, name="Laura_Peggy_paperwork")
m.addConstr(17*x1 + 5*x2 + 26*x3 + 6*x4 <= 232, name="all_paperwork")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Laura: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
    print("Hours worked by Paul: ", x3.varValue)
    print("Hours worked by Peggy: ", x4.varValue)
else:
    print("The model is infeasible")
