
from gurobipy import Model, GRB, quicksum

# Create a new model
model = Model("optimization_problem")

# Create variables
x = {}
item_names = ['black pens', 'manila envelopes', 'paper clips', 'lanyards', 'staplers', 'mechanical pencils']
for i in range(len(item_names)):
    x[i] = model.addVar(vtype=GRB.INTEGER, name=item_names[i])

# Set objective function
objective = 5*x[0]**2 + 3*x[0]*x[1] + 3*x[1]**2 + 2*x[1]*x[2] + 7*x[1]*x[3] + x[1]*x[5] + 5*x[2]**2 + 7*x[2]*x[3] + 6*x[2]*x[4] + x[2]*x[5] + 9*x[3]**2 + 5*x[3]*x[5] + 6*x[4]**2 + 7*x[4]*x[5] + 8*x[5]**2 + 8*x[1] + 9*x[2] + 8*x[4] + 4*x[5]
model.setObjective(objective, GRB.MAXIMIZE)


# Add constraints
sustainability_scores = [5, 3, 9, 3, 8, 11]
workplace_safety_impact = [4, 1, 11, 17, 11, 14]
resource_constraints = [
    {'name': 'r0', 'upper_bound': 251, 'values': sustainability_scores},
    {'name': 'r1', 'upper_bound': 191, 'values': workplace_safety_impact}
]

for r in resource_constraints:
    model.addConstr(quicksum(r['values'][i] * x[i] for i in range(len(item_names))) <= r['upper_bound'], r['name'])

# Add other constraints from the problem description (translated from symbolic form)
model.addConstr(3*x[3] + 11*x[5] >= 22)
model.addConstr(9*x[2] + 8*x[4] + 11*x[5] >= 25)
# ... (add all remaining constraints similarly)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for i in range(len(item_names)):
        print(f"{item_names[i]}: {x[i].x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

