
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="office_chairs")
x1 = m.addVar(vtype=GRB.INTEGER, name="color_printers")

# Set the objective function
m.setObjective(7.49*x0 + 9.65*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(19*x0 + 16*x1 >= 25, "storage_minimum")
m.addConstr(8*x0 + 21*x1 >= 30, "cost_minimum")
m.addConstr(5*x0 - 7*x1 >= 0, "office_chairs_vs_printers")
m.addConstr(19*x0 + 16*x1 <= 110, "storage_maximum")
m.addConstr(8*x0 + 21*x1 <= 79, "cost_maximum")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Office Chairs: {x0.x}")
    print(f"Color Printers: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
