
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name="office_chairs")
    x2 = model.addVar(vtype=gurobi.GRB.INTEGER, name="color_printers")

    # Objective function
    model.setObjective(7.49 * x1 + 9.65 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(19 * x1 + 16 * x2 >= 25, name="storage_space_min")
    model.addConstr(8 * x1 + 21 * x2 >= 30, name="dollar_cost_min")
    model.addConstr(5 * x1 - 7 * x2 >= 0, name="linear_constraint")
    model.addConstr(19 * x1 + 16 * x2 <= 71, name="storage_space_max")
    model.addConstr(8 * x1 + 21 * x2 <= 60, name="dollar_cost_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Office chairs: {x1.varValue}")
        print(f"Color printers: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
