
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
bill_hours = model.addVar(vtype=gp.GRB.INTEGER, name="bill_hours")
john_hours = model.addVar(vtype=gp.GRB.INTEGER, name="john_hours")
mary_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="mary_hours")
peggy_hours = model.addVar(vtype=gp.GRB.INTEGER, name="peggy_hours")


# Set objective function
model.setObjective(3.85 * bill_hours + 5.18 * john_hours + 2.03 * mary_hours + 3.6 * peggy_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * bill_hours + 8 * mary_hours >= 33)
model.addConstr(3 * bill_hours + 8 * mary_hours + 22 * peggy_hours >= 82)
model.addConstr(3 * bill_hours + 17 * john_hours + 8 * mary_hours >= 82)
model.addConstr(3 * bill_hours + 8 * mary_hours + 22 * peggy_hours >= 53)
model.addConstr(3 * bill_hours + 17 * john_hours + 8 * mary_hours >= 53)
model.addConstr(22 * bill_hours + 13 * peggy_hours <= 186)
model.addConstr(15 * mary_hours + 13 * peggy_hours <= 217)
model.addConstr(22 * bill_hours + 15 * mary_hours <= 262)
model.addConstr(4 * john_hours + 13 * peggy_hours <= 162)
model.addConstr(4 * john_hours + 15 * mary_hours <= 255)
model.addConstr(4 * john_hours + 15 * mary_hours + 13 * peggy_hours <= 247)
model.addConstr(22 * bill_hours + 4 * john_hours + 15 * mary_hours <= 200)
model.addConstr(22 * bill_hours + 15 * mary_hours + 13 * peggy_hours <= 192)
model.addConstr(22 * bill_hours + 4 * john_hours + 15 * mary_hours + 13 * peggy_hours <= 192)
model.addConstr(8 * mary_hours + 22 * peggy_hours <= 254)
model.addConstr(17 * john_hours + 8 * mary_hours <= 209)
model.addConstr(17 * john_hours + 22 * peggy_hours <= 242)
model.addConstr(3 * bill_hours + 22 * peggy_hours <= 192)
model.addConstr(3 * bill_hours + 17 * john_hours + 22 * peggy_hours <= 329)
model.addConstr(17 * john_hours + 8 * mary_hours + 22 * peggy_hours <= 291)
model.addConstr(3 * bill_hours + 17 * john_hours + 8 * mary_hours + 22 * peggy_hours <= 291)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Bill's hours:", bill_hours.x)
    print("John's hours:", john_hours.x)
    print("Mary's hours:", mary_hours.x)
    print("Peggy's hours:", peggy_hours.x)
    print("Objective value:", model.objVal)
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print("Optimization terminated with status:", model.status)

