
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Bill
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by John
    x2 = model.addVar(name="x2")  # hours worked by Mary
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy

    # Objective function
    model.setObjective(3.85 * x0 + 5.18 * x1 + 2.03 * x2 + 3.6 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3 * x0 + 8 * x2 >= 33)
    model.addConstr(3 * x0 + 22 * x3 >= 82)
    model.addConstr(3 * x0 + 17 * x1 + 8 * x2 >= 82)
    model.addConstr(3 * x0 + 22 * x3 >= 53)
    model.addConstr(3 * x0 + 17 * x1 + 8 * x2 >= 53)
    model.addConstr(22 * x0 + 13 * x3 <= 186)
    model.addConstr(15 * x2 + 13 * x3 <= 217)
    model.addConstr(22 * x0 + 15 * x2 <= 262)
    model.addConstr(4 * x1 + 13 * x3 <= 162)
    model.addConstr(4 * x1 + 15 * x2 <= 255)
    model.addConstr(4 * x1 + 15 * x2 + 13 * x3 <= 247)
    model.addConstr(22 * x0 + 4 * x1 + 15 * x2 <= 200)
    model.addConstr(22 * x0 + 15 * x2 + 13 * x3 <= 192)
    model.addConstr(22 * x0 + 4 * x1 + 15 * x2 + 13 * x3 <= 192)
    model.addConstr(8 * x2 + 22 * x3 <= 254)
    model.addConstr(17 * x1 + 8 * x2 <= 209)
    model.addConstr(17 * x1 + 22 * x3 <= 242)
    model.addConstr(3 * x0 + 22 * x3 <= 192)
    model.addConstr(3 * x0 + 17 * x1 + 22 * x3 <= 329)
    model.addConstr(17 * x1 + 8 * x2 + 22 * x3 <= 291)
    model.addConstr(3 * x0 + 17 * x1 + 8 * x2 + 22 * x3 <= 291)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Bill: ", x0.varValue)
        print("Hours worked by John: ", x1.varValue)
        print("Hours worked by Mary: ", x2.varValue)
        print("Hours worked by Peggy: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
