
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="x0")  # Peggy
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # Paul
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2") # Bill
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="x3") # Ringo
x4 = m.addVar(vtype=GRB.CONTINUOUS, name="x4") # Bobby


# Set objective function
m.setObjective(1.81*x0**2 + 1.02*x0*x1 + 8.68*x0*x3 + 2.04*x0*x4 + 6.6*x1**2 + 2.06*x2*x3 + 8.48*x2*x4 + 3.68*x3*x4 + 6.35*x0 + 9.93*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x3 + 3*x4 >= 51)
m.addConstr(8*x0 + 12*x2 + 3*x4 >= 50)
m.addConstr(7*x2 + 5*x3 >= 38)
m.addConstr(10*x1 + 5*x3 >= 48)
m.addConstr(2*x0**2 + 10*x1**2 >= 48)
m.addConstr(10*x1**2 + 2*x4**2 >= 41)
m.addConstr(9*x1**2 + 5*x2**2 + 12*x4**2 >= 25)
m.addConstr(9*x1 + 5*x2 + 5*x3 >= 25)
m.addConstr(2*x0 + 5*x2 + 5*x3 >= 25)
m.addConstr(2*x0 + 9*x1 + 5*x3 >= 25)
m.addConstr(9*x1**2 + 5*x3**2 + 12*x4**2 >= 25)
m.addConstr(2*x0**2 + 5*x2**2 + 12*x4**2 >= 25)
m.addConstr(9*x1 + 5*x2 + 12*x4 >= 19)
m.addConstr(9*x1 + 5*x2 + 5*x3 >= 19)
m.addConstr(2*x0 + 5*x2 + 5*x3 >= 19)
m.addConstr(2*x0 + 9*x1 + 5*x3 >= 19)
m.addConstr(9*x1 + 5*x3 + 12*x4 >= 19)
m.addConstr(2*x0 + 5*x2 + 12*x4 >= 19)
m.addConstr(9*x1 + 5*x2 + 12*x4 >= 22)
m.addConstr(9*x1 + 5*x2 + 5*x3 >= 22)
m.addConstr(2*x0 + 5*x2 + 5*x3 >= 22)
m.addConstr(2*x0 + 9*x1 + 5*x3 >= 22)
m.addConstr(9*x1**2 + 5*x3**2 + 12*x4**2 >= 22)
m.addConstr(2*x0 + 5*x2 + 12*x4 >= 22)
m.addConstr(9*x1 + 5*x2 + 12*x4 >= 23)
m.addConstr(9*x1 + 5*x2 + 5*x3 >= 23)
m.addConstr(2*x0**2 + 5*x2**2 + 5*x3**2 >= 23)
m.addConstr(2*x0 + 9*x1 + 5*x3 >= 23)
m.addConstr(9*x1 + 5*x3 + 12*x4 >= 23)
m.addConstr(2*x0 + 5*x2 + 12*x4 >= 23)
m.addConstr(9*x1**2 + 5*x2**2 + 12*x4**2 >= 22)
m.addConstr(9*x1 + 5*x2 + 5*x3 >= 22)
m.addConstr(2*x0 + 5*x2 + 5*x3 >= 22)
m.addConstr(2*x0 + 9*x1 + 5*x3 >= 22)
m.addConstr(9*x1 + 5*x3 + 12*x4 >= 22)
m.addConstr(2*x0**2 + 5*x2**2 + 12*x4**2 >= 22)
m.addConstr(9*x1 + 5*x2 + 12*x4 >= 22)
m.addConstr(9*x1 + 5*x2 + 5*x3 >= 22)
m.addConstr(2*x0 + 5*x2 + 5*x3 >= 22)
m.addConstr(2*x0**2 + 9*x1**2 + 5*x3**2 >= 22)
m.addConstr(9*x1 + 5*x3 + 12*x4 >= 22)
m.addConstr(2*x0**2 + 5*x2**2 + 12*x4**2 >= 22)


# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

