
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    dale_hours = model.addVar(name="dale_hours")
    bobby_hours = model.addVar(name="bobby_hours")
    jean_hours = model.addVar(name="jean_hours")


    # Set objective function
    model.setObjective(7.88*dale_hours**2 + 3.37*dale_hours*jean_hours + 5.46*bobby_hours*jean_hours + 4.27*jean_hours**2 + 7.6*dale_hours + 3.89*bobby_hours + 7.16*jean_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(18*dale_hours + 22*bobby_hours >= 51, "paperwork_competence_min")
    model.addConstr(22*bobby_hours**2 + 9*jean_hours**2 >= 38, "paperwork_competence_squared_min")
    model.addConstr(12*dale_hours + 27*bobby_hours >= 20, "likelihood_to_quit_min")
    model.addConstr(18*dale_hours + 22*bobby_hours <= 236, "paperwork_competence_max_dale_bobby")
    model.addConstr(18*dale_hours + 22*bobby_hours + 9*jean_hours <= 236, "paperwork_competence_max_all")
    model.addConstr(12*dale_hours + 27*bobby_hours <= 135, "likelihood_to_quit_max_dale_bobby")
    model.addConstr(27*bobby_hours + 13*jean_hours <= 144, "likelihood_to_quit_max_bobby_jean")
    model.addConstr(12*dale_hours + 27*bobby_hours + 13*jean_hours <= 144, "likelihood_to_quit_max_all")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Dale Hours: %g' % dale_hours.x)
        print('Bobby Hours: %g' % bobby_hours.x)
        print('Jean Hours: %g' % jean_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
