
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Dale')
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Bobby')
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Jean')

    # Define the objective function
    model.setObjective(7.88*x0**2 + 3.37*x0*x2 + 5.46*x1*x2 + 4.27*x2**2 + 7.6*x0 + 3.89*x1 + 7.16*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(18*x0 <= 261)
    model.addConstr(12*x0 <= 159)
    model.addConstr(22*x1 <= 261)
    model.addConstr(27*x1 <= 159)
    model.addConstr(9*x2 <= 261)
    model.addConstr(13*x2 <= 159)
    model.addConstr(18*x0 + 22*x1 >= 51)
    model.addConstr(22**2*x1**2 + 9**2*x2**2 >= 38)
    model.addConstr(12*x0 + 27*x1 >= 20)
    model.addConstr(18*x0 + 22*x1 <= 236)
    model.addConstr(18*x0 + 22*x1 + 9*x2 <= 236)
    model.addConstr(12*x0 + 27*x1 <= 135)
    model.addConstr(27*x1 + 13*x2 <= 144)
    model.addConstr(12*x0 + 27*x1 + 13*x2 <= 144)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Dale: ', x0.x)
        print('Hours worked by Bobby: ', x1.x)
        print('Hours worked by Jean: ', x2.x)
    else:
        print('The model is infeasible')

solve_optimization_problem()
