
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b3 = m.addVar(lb=0, name="vitamin_b3")
vitamin_e = m.addVar(lb=0, name="vitamin_e")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b7")
vitamin_b9 = m.addVar(lb=0, name="vitamin_b9")


# Set objective function
obj = 7*vitamin_b3**2 + 5*vitamin_b3*vitamin_e + 8*vitamin_b3*vitamin_b7 + 3*vitamin_e**2 + 2*vitamin_e*vitamin_b7 + 8*vitamin_e*vitamin_b9 + 7*vitamin_b7*vitamin_b9 + 4*vitamin_b9**2 + 6*vitamin_b3 + 3*vitamin_e + 2*vitamin_b9
m.setObjective(obj, gp.GRB.MAXIMIZE)

# Add constraints
resource_constraints = {
    'r0': {'upper_bound': 127, 'x0': 8, 'x1': 7, 'x2': 3, 'x3': 5},
    'r1': {'upper_bound': 76, 'x0': 3, 'x1': 7, 'x2': 8, 'x3': 6},
    'r2': {'upper_bound': 87, 'x0': 6, 'x1': 6, 'x2': 6, 'x3': 3},
    'r3': {'upper_bound': 41, 'x0': 2, 'x1': 3, 'x2': 1, 'x3': 3}
}

constraints = [
    8*vitamin_b3 + 5*vitamin_b9 >= 16,
    7*vitamin_e + 5*vitamin_b9 >= 11,
    7*vitamin_e + 3*vitamin_b7 + 5*vitamin_b9 >= 22,
    7*vitamin_e + 6*vitamin_b9 >= 7,
    3*vitamin_b3 + 8*vitamin_b7 >= 12,
    8*vitamin_b7 + 6*vitamin_b9 >= 10,
    3*vitamin_b3**2 + 7*vitamin_e**2 + 8*vitamin_b7**2 >= 10,
    3*vitamin_b3**2 + 7*vitamin_e**2 + 6*vitamin_b9**2 >= 10,
    3*vitamin_b3 + 7*vitamin_e + 8*vitamin_b7 >= 9,
    3*vitamin_b3 + 7*vitamin_e + 6*vitamin_b9 >= 9,
    6*vitamin_b3 + 3*vitamin_b9 >= 11,
    6*vitamin_e + 3*vitamin_b9 >= 10,
    6*vitamin_e + 6*vitamin_b7 >= 14,
    6*vitamin_b3 + 6*vitamin_e + 3*vitamin_b9 >= 21,
    -10*vitamin_b3**2 - 5*vitamin_b7**2 + 8*vitamin_b9**2 >= 0,
    8*vitamin_b3**2 + 7*vitamin_e**2 <= 110,
    7*vitamin_e + 3*vitamin_b7 <= 82,
    8*vitamin_b3**2 + 3*vitamin_b7**2 <= 65,
    8*vitamin_b3**2 + 7*vitamin_e**2 + 5*vitamin_b9**2 <= 64,
    8*vitamin_b3 + 7*vitamin_e + 3*vitamin_b7 + 5*vitamin_b9 <= 64,
    7*vitamin_e + 6*vitamin_b9 <= 41,
    3*vitamin_b3 + 7*vitamin_e <= 54,
    3*vitamin_b3 + 6*vitamin_b9 <= 70,
    3*vitamin_b3 + 7*vitamin_e + 8*vitamin_b7 + 6*vitamin_b9 <= 70,
    6*vitamin_b3 + 6*vitamin_b7 <= 66,
    6*vitamin_e**2 + 3*vitamin_b9**2 <= 35,
    6*vitamin_e + 6*vitamin_b7 <= 52,
    6*vitamin_b3 + 6*vitamin_e + 6*vitamin_b7 + 3*vitamin_b9 <= 52,
    3*vitamin_e + 1*vitamin_b7 <= 17,
    2*vitamin_b3**2 + 3*vitamin_b9**2 <= 17,
    2*vitamin_b3 + 1*vitamin_b7 <= 22,
    1*vitamin_b7 + 3*vitamin_b9 <= 26,
    3*vitamin_e + 1*vitamin_b7 + 3*vitamin_b9 <= 28,
    2*vitamin_b3 + 3*vitamin_e + 3*vitamin_b9 <= 21,
    2*vitamin_b3 + 1*vitamin_b7 + 3*vitamin_b9 <= 37,
    2*vitamin_b3 + 3*vitamin_e + 1*vitamin_b7 + 3*vitamin_b9 <= 37
]

for constraint in constraints:
    m.addConstr(constraint)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

